/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CustomField;
import com.google.ads.admanager.v1.CustomFieldName;
import com.google.ads.admanager.v1.CustomFieldServiceSettings;
import com.google.ads.admanager.v1.GetCustomFieldRequest;
import com.google.ads.admanager.v1.ListCustomFieldsRequest;
import com.google.ads.admanager.v1.ListCustomFieldsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStub;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CustomFieldServiceClient
implements BackgroundResource {
    private final CustomFieldServiceSettings settings;
    private final CustomFieldServiceStub stub;

    public static final CustomFieldServiceClient create() throws IOException {
        return CustomFieldServiceClient.create(CustomFieldServiceSettings.newBuilder().build());
    }

    public static final CustomFieldServiceClient create(CustomFieldServiceSettings settings) throws IOException {
        return new CustomFieldServiceClient(settings);
    }

    public static final CustomFieldServiceClient create(CustomFieldServiceStub stub) {
        return new CustomFieldServiceClient(stub);
    }

    protected CustomFieldServiceClient(CustomFieldServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomFieldServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomFieldServiceClient(CustomFieldServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomFieldServiceSettings getSettings() {
        return this.settings;
    }

    public CustomFieldServiceStub getStub() {
        return this.stub;
    }

    public final CustomField getCustomField(CustomFieldName name) {
        GetCustomFieldRequest request = GetCustomFieldRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomField(request);
    }

    public final CustomField getCustomField(String name) {
        GetCustomFieldRequest request = GetCustomFieldRequest.newBuilder().setName(name).build();
        return this.getCustomField(request);
    }

    public final CustomField getCustomField(GetCustomFieldRequest request) {
        return (CustomField)this.getCustomFieldCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomFieldRequest, CustomField> getCustomFieldCallable() {
        return this.stub.getCustomFieldCallable();
    }

    public final ListCustomFieldsPagedResponse listCustomFields(NetworkName parent) {
        ListCustomFieldsRequest request = ListCustomFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomFields(request);
    }

    public final ListCustomFieldsPagedResponse listCustomFields(String parent) {
        ListCustomFieldsRequest request = ListCustomFieldsRequest.newBuilder().setParent(parent).build();
        return this.listCustomFields(request);
    }

    public final ListCustomFieldsPagedResponse listCustomFields(ListCustomFieldsRequest request) {
        return (ListCustomFieldsPagedResponse)((Object)this.listCustomFieldsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsPagedResponse> listCustomFieldsPagedCallable() {
        return this.stub.listCustomFieldsPagedCallable();
    }

    public final UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsResponse> listCustomFieldsCallable() {
        return this.stub.listCustomFieldsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCustomFieldsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField, ListCustomFieldsPage, ListCustomFieldsFixedSizeCollection> {
        private ListCustomFieldsFixedSizeCollection(List<ListCustomFieldsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomFieldsFixedSizeCollection createEmptyCollection() {
            return new ListCustomFieldsFixedSizeCollection(null, 0);
        }

        protected ListCustomFieldsFixedSizeCollection createCollection(List<ListCustomFieldsPage> pages, int collectionSize) {
            return new ListCustomFieldsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomFieldsPage
    extends AbstractPage<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField, ListCustomFieldsPage> {
        private ListCustomFieldsPage(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ListCustomFieldsResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomFieldsPage createEmptyPage() {
            return new ListCustomFieldsPage(null, null);
        }

        protected ListCustomFieldsPage createPage(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ListCustomFieldsResponse response) {
            return new ListCustomFieldsPage(context, response);
        }

        public ApiFuture<ListCustomFieldsPage> createPageAsync(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ApiFuture<ListCustomFieldsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomFieldsPagedResponse
    extends AbstractPagedListResponse<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField, ListCustomFieldsPage, ListCustomFieldsFixedSizeCollection> {
        public static ApiFuture<ListCustomFieldsPagedResponse> createAsync(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ApiFuture<ListCustomFieldsResponse> futureResponse) {
            ApiFuture<ListCustomFieldsPage> futurePage = ListCustomFieldsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomFieldsPagedResponse((ListCustomFieldsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomFieldsPagedResponse(ListCustomFieldsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomFieldsFixedSizeCollection.createEmptyCollection());
        }
    }
}

