/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CustomTargetingValue;
import com.google.ads.admanager.v1.CustomTargetingValueServiceClient;
import com.google.ads.admanager.v1.GetCustomTargetingValueRequest;
import com.google.ads.admanager.v1.ListCustomTargetingValuesRequest;
import com.google.ads.admanager.v1.ListCustomTargetingValuesResponse;
import com.google.ads.admanager.v1.stub.CustomTargetingValueServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCustomTargetingValueServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CustomTargetingValueServiceStubSettings
extends StubSettings<CustomTargetingValueServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetCustomTargetingValueRequest, CustomTargetingValue> getCustomTargetingValueSettings;
    private final PagedCallSettings<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse> listCustomTargetingValuesSettings;
    private static final PagedListDescriptor<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue> LIST_CUSTOM_TARGETING_VALUES_PAGE_STR_DESC = new PagedListDescriptor<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomTargetingValuesRequest injectToken(ListCustomTargetingValuesRequest payload, String token) {
            return ListCustomTargetingValuesRequest.newBuilder((ListCustomTargetingValuesRequest)payload).setPageToken(token).build();
        }

        public ListCustomTargetingValuesRequest injectPageSize(ListCustomTargetingValuesRequest payload, int pageSize) {
            return ListCustomTargetingValuesRequest.newBuilder((ListCustomTargetingValuesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomTargetingValuesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomTargetingValuesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CustomTargetingValue> extractResources(ListCustomTargetingValuesResponse payload) {
            return payload.getCustomTargetingValuesList();
        }
    };
    private static final PagedListResponseFactory<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse> LIST_CUSTOM_TARGETING_VALUES_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse>(){

        public ApiFuture<CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse> callable, ListCustomTargetingValuesRequest request, ApiCallContext context, ApiFuture<ListCustomTargetingValuesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOM_TARGETING_VALUES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse.createAsync((PageContext<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCustomTargetingValueRequest, CustomTargetingValue> getCustomTargetingValueSettings() {
        return this.getCustomTargetingValueSettings;
    }

    public PagedCallSettings<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse> listCustomTargetingValuesSettings() {
        return this.listCustomTargetingValuesSettings;
    }

    public CustomTargetingValueServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCustomTargetingValueServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CustomTargetingValueServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CustomTargetingValueServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CustomTargetingValueServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCustomTargetingValueSettings = settingsBuilder.getCustomTargetingValueSettings().build();
        this.listCustomTargetingValuesSettings = settingsBuilder.listCustomTargetingValuesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CustomTargetingValueServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCustomTargetingValueRequest, CustomTargetingValue> getCustomTargetingValueSettings;
        private final PagedCallSettings.Builder<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse> listCustomTargetingValuesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCustomTargetingValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCustomTargetingValuesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOM_TARGETING_VALUES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomTargetingValueSettings, this.listCustomTargetingValuesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CustomTargetingValueServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCustomTargetingValueSettings = settings.getCustomTargetingValueSettings.toBuilder();
            this.listCustomTargetingValuesSettings = settings.listCustomTargetingValuesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomTargetingValueSettings, this.listCustomTargetingValuesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CustomTargetingValueServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CustomTargetingValueServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CustomTargetingValueServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CustomTargetingValueServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCustomTargetingValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCustomTargetingValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCustomTargetingValueRequest, CustomTargetingValue> getCustomTargetingValueSettings() {
            return this.getCustomTargetingValueSettings;
        }

        public PagedCallSettings.Builder<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValueServiceClient.ListCustomTargetingValuesPagedResponse> listCustomTargetingValuesSettings() {
            return this.listCustomTargetingValuesSettings;
        }

        public CustomTargetingValueServiceStubSettings build() throws IOException {
            return new CustomTargetingValueServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

