/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetUserRequest;
import com.google.ads.admanager.v1.User;
import com.google.ads.admanager.v1.UserName;
import com.google.ads.admanager.v1.UserServiceSettings;
import com.google.ads.admanager.v1.stub.UserServiceStub;
import com.google.ads.admanager.v1.stub.UserServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class UserServiceClient
implements BackgroundResource {
    private final UserServiceSettings settings;
    private final UserServiceStub stub;

    public static final UserServiceClient create() throws IOException {
        return UserServiceClient.create(UserServiceSettings.newBuilder().build());
    }

    public static final UserServiceClient create(UserServiceSettings settings) throws IOException {
        return new UserServiceClient(settings);
    }

    public static final UserServiceClient create(UserServiceStub stub) {
        return new UserServiceClient(stub);
    }

    protected UserServiceClient(UserServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected UserServiceClient(UserServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UserServiceSettings getSettings() {
        return this.settings;
    }

    public UserServiceStub getStub() {
        return this.stub;
    }

    public final User getUser(UserName name) {
        GetUserRequest request = GetUserRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUser(request);
    }

    public final User getUser(String name) {
        GetUserRequest request = GetUserRequest.newBuilder().setName(name).build();
        return this.getUser(request);
    }

    public final User getUser(GetUserRequest request) {
        return (User)this.getUserCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserRequest, User> getUserCallable() {
        return this.stub.getUserCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

