/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetTaxonomyCategoryRequest;
import com.google.ads.admanager.v1.ListTaxonomyCategoriesRequest;
import com.google.ads.admanager.v1.ListTaxonomyCategoriesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.TaxonomyCategory;
import com.google.ads.admanager.v1.TaxonomyCategoryName;
import com.google.ads.admanager.v1.TaxonomyCategoryServiceSettings;
import com.google.ads.admanager.v1.stub.TaxonomyCategoryServiceStub;
import com.google.ads.admanager.v1.stub.TaxonomyCategoryServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TaxonomyCategoryServiceClient
implements BackgroundResource {
    private final TaxonomyCategoryServiceSettings settings;
    private final TaxonomyCategoryServiceStub stub;

    public static final TaxonomyCategoryServiceClient create() throws IOException {
        return TaxonomyCategoryServiceClient.create(TaxonomyCategoryServiceSettings.newBuilder().build());
    }

    public static final TaxonomyCategoryServiceClient create(TaxonomyCategoryServiceSettings settings) throws IOException {
        return new TaxonomyCategoryServiceClient(settings);
    }

    public static final TaxonomyCategoryServiceClient create(TaxonomyCategoryServiceStub stub) {
        return new TaxonomyCategoryServiceClient(stub);
    }

    protected TaxonomyCategoryServiceClient(TaxonomyCategoryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TaxonomyCategoryServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected TaxonomyCategoryServiceClient(TaxonomyCategoryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TaxonomyCategoryServiceSettings getSettings() {
        return this.settings;
    }

    public TaxonomyCategoryServiceStub getStub() {
        return this.stub;
    }

    public final TaxonomyCategory getTaxonomyCategory(TaxonomyCategoryName name) {
        GetTaxonomyCategoryRequest request = GetTaxonomyCategoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTaxonomyCategory(request);
    }

    public final TaxonomyCategory getTaxonomyCategory(String name) {
        GetTaxonomyCategoryRequest request = GetTaxonomyCategoryRequest.newBuilder().setName(name).build();
        return this.getTaxonomyCategory(request);
    }

    public final TaxonomyCategory getTaxonomyCategory(GetTaxonomyCategoryRequest request) {
        return (TaxonomyCategory)this.getTaxonomyCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaxonomyCategoryRequest, TaxonomyCategory> getTaxonomyCategoryCallable() {
        return this.stub.getTaxonomyCategoryCallable();
    }

    public final ListTaxonomyCategoriesPagedResponse listTaxonomyCategories(NetworkName parent) {
        ListTaxonomyCategoriesRequest request = ListTaxonomyCategoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTaxonomyCategories(request);
    }

    public final ListTaxonomyCategoriesPagedResponse listTaxonomyCategories(String parent) {
        ListTaxonomyCategoriesRequest request = ListTaxonomyCategoriesRequest.newBuilder().setParent(parent).build();
        return this.listTaxonomyCategories(request);
    }

    public final ListTaxonomyCategoriesPagedResponse listTaxonomyCategories(ListTaxonomyCategoriesRequest request) {
        return (ListTaxonomyCategoriesPagedResponse)((Object)this.listTaxonomyCategoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesPagedResponse> listTaxonomyCategoriesPagedCallable() {
        return this.stub.listTaxonomyCategoriesPagedCallable();
    }

    public final UnaryCallable<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse> listTaxonomyCategoriesCallable() {
        return this.stub.listTaxonomyCategoriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTaxonomyCategoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory, ListTaxonomyCategoriesPage, ListTaxonomyCategoriesFixedSizeCollection> {
        private ListTaxonomyCategoriesFixedSizeCollection(List<ListTaxonomyCategoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTaxonomyCategoriesFixedSizeCollection createEmptyCollection() {
            return new ListTaxonomyCategoriesFixedSizeCollection(null, 0);
        }

        protected ListTaxonomyCategoriesFixedSizeCollection createCollection(List<ListTaxonomyCategoriesPage> pages, int collectionSize) {
            return new ListTaxonomyCategoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTaxonomyCategoriesPage
    extends AbstractPage<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory, ListTaxonomyCategoriesPage> {
        private ListTaxonomyCategoriesPage(PageContext<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory> context, ListTaxonomyCategoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListTaxonomyCategoriesPage createEmptyPage() {
            return new ListTaxonomyCategoriesPage(null, null);
        }

        protected ListTaxonomyCategoriesPage createPage(PageContext<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory> context, ListTaxonomyCategoriesResponse response) {
            return new ListTaxonomyCategoriesPage(context, response);
        }

        public ApiFuture<ListTaxonomyCategoriesPage> createPageAsync(PageContext<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory> context, ApiFuture<ListTaxonomyCategoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTaxonomyCategoriesPagedResponse
    extends AbstractPagedListResponse<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory, ListTaxonomyCategoriesPage, ListTaxonomyCategoriesFixedSizeCollection> {
        public static ApiFuture<ListTaxonomyCategoriesPagedResponse> createAsync(PageContext<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory> context, ApiFuture<ListTaxonomyCategoriesResponse> futureResponse) {
            ApiFuture<ListTaxonomyCategoriesPage> futurePage = ListTaxonomyCategoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTaxonomyCategoriesPagedResponse((ListTaxonomyCategoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTaxonomyCategoriesPagedResponse(ListTaxonomyCategoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTaxonomyCategoriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

