/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.Creative;
import com.google.ads.admanager.v1.CreativeName;
import com.google.ads.admanager.v1.CreativeServiceSettings;
import com.google.ads.admanager.v1.GetCreativeRequest;
import com.google.ads.admanager.v1.ListCreativesRequest;
import com.google.ads.admanager.v1.ListCreativesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CreativeServiceStub;
import com.google.ads.admanager.v1.stub.CreativeServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CreativeServiceClient
implements BackgroundResource {
    private final CreativeServiceSettings settings;
    private final CreativeServiceStub stub;

    public static final CreativeServiceClient create() throws IOException {
        return CreativeServiceClient.create(CreativeServiceSettings.newBuilder().build());
    }

    public static final CreativeServiceClient create(CreativeServiceSettings settings) throws IOException {
        return new CreativeServiceClient(settings);
    }

    public static final CreativeServiceClient create(CreativeServiceStub stub) {
        return new CreativeServiceClient(stub);
    }

    protected CreativeServiceClient(CreativeServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CreativeServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CreativeServiceClient(CreativeServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CreativeServiceSettings getSettings() {
        return this.settings;
    }

    public CreativeServiceStub getStub() {
        return this.stub;
    }

    public final Creative getCreative(CreativeName name) {
        GetCreativeRequest request = GetCreativeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCreative(request);
    }

    public final Creative getCreative(String name) {
        GetCreativeRequest request = GetCreativeRequest.newBuilder().setName(name).build();
        return this.getCreative(request);
    }

    public final Creative getCreative(GetCreativeRequest request) {
        return (Creative)this.getCreativeCallable().call((Object)request);
    }

    public final UnaryCallable<GetCreativeRequest, Creative> getCreativeCallable() {
        return this.stub.getCreativeCallable();
    }

    public final ListCreativesPagedResponse listCreatives(NetworkName parent) {
        ListCreativesRequest request = ListCreativesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCreatives(request);
    }

    public final ListCreativesPagedResponse listCreatives(String parent) {
        ListCreativesRequest request = ListCreativesRequest.newBuilder().setParent(parent).build();
        return this.listCreatives(request);
    }

    public final ListCreativesPagedResponse listCreatives(ListCreativesRequest request) {
        return (ListCreativesPagedResponse)((Object)this.listCreativesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCreativesRequest, ListCreativesPagedResponse> listCreativesPagedCallable() {
        return this.stub.listCreativesPagedCallable();
    }

    public final UnaryCallable<ListCreativesRequest, ListCreativesResponse> listCreativesCallable() {
        return this.stub.listCreativesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCreativesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCreativesRequest, ListCreativesResponse, Creative, ListCreativesPage, ListCreativesFixedSizeCollection> {
        private ListCreativesFixedSizeCollection(List<ListCreativesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCreativesFixedSizeCollection createEmptyCollection() {
            return new ListCreativesFixedSizeCollection(null, 0);
        }

        protected ListCreativesFixedSizeCollection createCollection(List<ListCreativesPage> pages, int collectionSize) {
            return new ListCreativesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCreativesPage
    extends AbstractPage<ListCreativesRequest, ListCreativesResponse, Creative, ListCreativesPage> {
        private ListCreativesPage(PageContext<ListCreativesRequest, ListCreativesResponse, Creative> context, ListCreativesResponse response) {
            super(context, (Object)response);
        }

        private static ListCreativesPage createEmptyPage() {
            return new ListCreativesPage(null, null);
        }

        protected ListCreativesPage createPage(PageContext<ListCreativesRequest, ListCreativesResponse, Creative> context, ListCreativesResponse response) {
            return new ListCreativesPage(context, response);
        }

        public ApiFuture<ListCreativesPage> createPageAsync(PageContext<ListCreativesRequest, ListCreativesResponse, Creative> context, ApiFuture<ListCreativesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCreativesPagedResponse
    extends AbstractPagedListResponse<ListCreativesRequest, ListCreativesResponse, Creative, ListCreativesPage, ListCreativesFixedSizeCollection> {
        public static ApiFuture<ListCreativesPagedResponse> createAsync(PageContext<ListCreativesRequest, ListCreativesResponse, Creative> context, ApiFuture<ListCreativesResponse> futureResponse) {
            ApiFuture<ListCreativesPage> futurePage = ListCreativesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCreativesPagedResponse((ListCreativesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCreativesPagedResponse(ListCreativesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCreativesFixedSizeCollection.createEmptyCollection());
        }
    }
}

