/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Box;
import com.google.android.filament.Engine;
import com.google.android.filament.Entity;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.gltfio.Animator;

public class FilamentAsset {
    private long mNativeObject;
    private Animator mAnimator;
    private Engine mEngine;

    FilamentAsset(Engine engine, long nativeObject) {
        this.mEngine = engine;
        this.mNativeObject = nativeObject;
        this.mAnimator = null;
    }

    long getNativeObject() {
        return this.mNativeObject;
    }

    @Entity
    public int getRoot() {
        return FilamentAsset.nGetRoot(this.mNativeObject);
    }

    @Entity
    public int popRenderable() {
        return FilamentAsset.nPopRenderable(this.mNativeObject);
    }

    public int popRenderables(@Nullable @Entity int[] entities) {
        return FilamentAsset.nPopRenderables(this.mNativeObject, entities);
    }

    @NonNull
    @Entity
    public int[] getEntities() {
        int[] result = new int[FilamentAsset.nGetEntityCount(this.mNativeObject)];
        FilamentAsset.nGetEntities(this.mNativeObject, result);
        return result;
    }

    @NonNull
    @Entity
    public int[] getLightEntities() {
        int[] result = new int[FilamentAsset.nGetLightEntityCount(this.mNativeObject)];
        FilamentAsset.nGetLightEntities(this.mNativeObject, result);
        return result;
    }

    @NonNull
    @Entity
    public int[] getCameraEntities() {
        int[] result = new int[FilamentAsset.nGetCameraEntityCount(this.mNativeObject)];
        FilamentAsset.nGetCameraEntities(this.mNativeObject, result);
        return result;
    }

    @Entity
    public int getFirstEntityByName(String name) {
        return FilamentAsset.nGetFirstEntityByName(this.mNativeObject, name);
    }

    @NonNull
    @Entity
    public int[] getEntitiesByName(String name) {
        int[] result = new int[FilamentAsset.nGetEntitiesByName(this.mNativeObject, name, null)];
        FilamentAsset.nGetEntitiesByName(this.mNativeObject, name, result);
        return result;
    }

    @NonNull
    @Entity
    public int[] getEntitiesByPrefix(String prefix) {
        int[] result = new int[FilamentAsset.nGetEntitiesByPrefix(this.mNativeObject, prefix, null)];
        FilamentAsset.nGetEntitiesByPrefix(this.mNativeObject, prefix, result);
        return result;
    }

    @NonNull
    public MaterialInstance[] getMaterialInstances() {
        int count = FilamentAsset.nGetMaterialInstanceCount(this.mNativeObject);
        MaterialInstance[] result = new MaterialInstance[count];
        long[] natives = new long[count];
        FilamentAsset.nGetMaterialInstances(this.mNativeObject, natives);
        for (int i = 0; i < count; ++i) {
            result[i] = new MaterialInstance(this.mEngine, natives[i]);
        }
        return result;
    }

    @NonNull
    public Box getBoundingBox() {
        float[] box = new float[6];
        FilamentAsset.nGetBoundingBox(this.mNativeObject, box);
        return new Box(box[0], box[1], box[2], box[3], box[4], box[5]);
    }

    public String getName(@Entity int entity) {
        return FilamentAsset.nGetName(this.getNativeObject(), entity);
    }

    @Nullable
    public String getExtras(@Entity int entity) {
        return FilamentAsset.nGetExtras(this.mNativeObject, entity);
    }

    @NonNull
    public Animator getAnimator() {
        if (this.mAnimator != null) {
            return this.mAnimator;
        }
        long nativeAnimator = FilamentAsset.nGetAnimator(this.getNativeObject());
        if (nativeAnimator == 0L) {
            throw new IllegalStateException("Unable to create animator");
        }
        this.mAnimator = new Animator(nativeAnimator);
        return this.mAnimator;
    }

    @NonNull
    public String[] getResourceUris() {
        String[] uris = new String[FilamentAsset.nGetResourceUriCount(this.mNativeObject)];
        FilamentAsset.nGetResourceUris(this.mNativeObject, uris);
        return uris;
    }

    public void releaseSourceData() {
        FilamentAsset.nReleaseSourceData(this.mNativeObject);
    }

    void clearNativeObject() {
        if (this.mAnimator != null) {
            this.mAnimator.clearNativeObject();
        }
        this.mNativeObject = 0L;
    }

    private static native int nGetRoot(long var0);

    private static native int nPopRenderable(long var0);

    private static native int nPopRenderables(long var0, int[] var2);

    private static native int nGetEntityCount(long var0);

    private static native void nGetEntities(long var0, int[] var2);

    private static native int nGetFirstEntityByName(long var0, String var2);

    private static native int nGetEntitiesByName(long var0, String var2, int[] var3);

    private static native int nGetEntitiesByPrefix(long var0, String var2, int[] var3);

    private static native int nGetLightEntityCount(long var0);

    private static native void nGetLightEntities(long var0, int[] var2);

    private static native int nGetCameraEntityCount(long var0);

    private static native void nGetCameraEntities(long var0, int[] var2);

    private static native int nGetMaterialInstanceCount(long var0);

    private static native void nGetMaterialInstances(long var0, long[] var2);

    private static native void nGetBoundingBox(long var0, float[] var2);

    private static native String nGetName(long var0, int var2);

    private static native String nGetExtras(long var0, int var2);

    private static native long nGetAnimator(long var0);

    private static native int nGetResourceUriCount(long var0);

    private static native void nGetResourceUris(long var0, String[] var2);

    private static native void nReleaseSourceData(long var0);
}

