/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.utils.Bookmark;

public class Manipulator {
    private static final Mode[] sModeValues = Mode.values();
    private final long mNativeObject;

    private Manipulator(long nativeIndexBuffer) {
        this.mNativeObject = nativeIndexBuffer;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
        }
        finally {
            Manipulator.nDestroyManipulator(this.mNativeObject);
        }
    }

    public Mode getMode() {
        return sModeValues[Manipulator.nGetMode(this.mNativeObject)];
    }

    public void setViewport(int width, int height) {
        Manipulator.nSetViewport(this.mNativeObject, width, height);
    }

    public void getLookAt(@NonNull @Size(min=3L) float[] eyePosition, @NonNull @Size(min=3L) float[] targetPosition, @NonNull @Size(min=3L) float[] upward) {
        Manipulator.nGetLookAtFloat(this.mNativeObject, eyePosition, targetPosition, upward);
    }

    public void getLookAt(@NonNull @Size(min=3L) double[] eyePosition, @NonNull @Size(min=3L) double[] targetPosition, @NonNull @Size(min=3L) double[] upward) {
        Manipulator.nGetLookAtDouble(this.mNativeObject, eyePosition, targetPosition, upward);
    }

    @Nullable
    @Size(min=3L)
    public float[] raycast(int x, int y) {
        float[] result = new float[3];
        Manipulator.nRaycast(this.mNativeObject, x, y, result);
        return result;
    }

    public void grabBegin(int x, int y, boolean strafe) {
        Manipulator.nGrabBegin(this.mNativeObject, x, y, strafe);
    }

    public void grabUpdate(int x, int y) {
        Manipulator.nGrabUpdate(this.mNativeObject, x, y);
    }

    public void grabEnd() {
        Manipulator.nGrabEnd(this.mNativeObject);
    }

    public void keyDown(Key key) {
        Manipulator.nKeyDown(this.mNativeObject, key.ordinal());
    }

    public void keyUp(Key key) {
        Manipulator.nKeyUp(this.mNativeObject, key.ordinal());
    }

    public void scroll(int x, int y, float scrolldelta) {
        Manipulator.nScroll(this.mNativeObject, x, y, scrolldelta);
    }

    public void update(float deltaTime) {
        Manipulator.nUpdate(this.mNativeObject, deltaTime);
    }

    public Bookmark getCurrentBookmark() {
        return new Bookmark(Manipulator.nGetCurrentBookmark(this.mNativeObject));
    }

    public Bookmark getHomeBookmark() {
        return new Bookmark(Manipulator.nGetHomeBookmark(this.mNativeObject));
    }

    public void jumpToBookmark(Bookmark bookmark) {
        Manipulator.nJumpToBookmark(this.mNativeObject, bookmark.getNativeObject());
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderViewport(long var0, int var2, int var3);

    private static native void nBuilderTargetPosition(long var0, float var2, float var3, float var4);

    private static native void nBuilderUpVector(long var0, float var2, float var3, float var4);

    private static native void nBuilderZoomSpeed(long var0, float var2);

    private static native void nBuilderOrbitHomePosition(long var0, float var2, float var3, float var4);

    private static native void nBuilderOrbitSpeed(long var0, float var2, float var3);

    private static native void nBuilderFovDirection(long var0, int var2);

    private static native void nBuilderFovDegrees(long var0, float var2);

    private static native void nBuilderFarPlane(long var0, float var2);

    private static native void nBuilderMapExtent(long var0, float var2, float var3);

    private static native void nBuilderMapMinDistance(long var0, float var2);

    private static native void nBuilderFlightStartPosition(long var0, float var2, float var3, float var4);

    private static native void nBuilderFlightStartOrientation(long var0, float var2, float var3);

    private static native void nBuilderFlightMaxMoveSpeed(long var0, float var2);

    private static native void nBuilderFlightSpeedSteps(long var0, int var2);

    private static native void nBuilderFlightPanSpeed(long var0, float var2, float var3);

    private static native void nBuilderFlightMoveDamping(long var0, float var2);

    private static native void nBuilderGroundPlane(long var0, float var2, float var3, float var4, float var5);

    private static native long nBuilderBuild(long var0, int var2);

    private static native void nDestroyManipulator(long var0);

    private static native int nGetMode(long var0);

    private static native void nSetViewport(long var0, int var2, int var3);

    private static native void nGetLookAtFloat(long var0, float[] var2, float[] var3, float[] var4);

    private static native void nGetLookAtDouble(long var0, double[] var2, double[] var3, double[] var4);

    private static native void nRaycast(long var0, int var2, int var3, float[] var4);

    private static native void nGrabBegin(long var0, int var2, int var3, boolean var4);

    private static native void nGrabUpdate(long var0, int var2, int var3);

    private static native void nGrabEnd(long var0);

    private static native void nKeyDown(long var0, int var2);

    private static native void nKeyUp(long var0, int var2);

    private static native void nScroll(long var0, int var2, int var3, float var4);

    private static native void nUpdate(long var0, float var2);

    private static native long nGetCurrentBookmark(long var0);

    private static native long nGetHomeBookmark(long var0);

    private static native void nJumpToBookmark(long var0, long var2);

    static /* synthetic */ long access$000() {
        return Manipulator.nCreateBuilder();
    }

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = Manipulator.access$000();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder viewport(@IntRange(from=1L) int width, @IntRange(from=1L) int height) {
            Manipulator.nBuilderViewport(this.mNativeBuilder, width, height);
            return this;
        }

        @NonNull
        public Builder targetPosition(float x, float y, float z) {
            Manipulator.nBuilderTargetPosition(this.mNativeBuilder, x, y, z);
            return this;
        }

        @NonNull
        public Builder upVector(float x, float y, float z) {
            Manipulator.nBuilderUpVector(this.mNativeBuilder, x, y, z);
            return this;
        }

        @NonNull
        public Builder zoomSpeed(float arg) {
            Manipulator.nBuilderZoomSpeed(this.mNativeBuilder, arg);
            return this;
        }

        @NonNull
        public Builder orbitHomePosition(float x, float y, float z) {
            Manipulator.nBuilderOrbitHomePosition(this.mNativeBuilder, x, y, z);
            return this;
        }

        @NonNull
        public Builder orbitSpeed(float x, float y) {
            Manipulator.nBuilderOrbitSpeed(this.mNativeBuilder, x, y);
            return this;
        }

        @NonNull
        public Builder fovDirection(Fov fov) {
            Manipulator.nBuilderFovDirection(this.mNativeBuilder, fov.ordinal());
            return this;
        }

        @NonNull
        public Builder fovDegrees(float arg) {
            Manipulator.nBuilderFovDegrees(this.mNativeBuilder, arg);
            return this;
        }

        @NonNull
        public Builder farPlane(float arg) {
            Manipulator.nBuilderFarPlane(this.mNativeBuilder, arg);
            return this;
        }

        @NonNull
        public Builder mapExtent(float width, float height) {
            Manipulator.nBuilderMapExtent(this.mNativeBuilder, width, height);
            return this;
        }

        @NonNull
        public Builder mapMinDistance(float arg) {
            Manipulator.nBuilderMapMinDistance(this.mNativeBuilder, arg);
            return this;
        }

        public Builder flightStartPosition(float x, float y, float z) {
            Manipulator.nBuilderFlightStartPosition(this.mNativeBuilder, x, y, z);
            return this;
        }

        public Builder flightStartOrientation(float pitch, float yaw) {
            Manipulator.nBuilderFlightStartOrientation(this.mNativeBuilder, pitch, yaw);
            return this;
        }

        public Builder flightMaxMoveSpeed(float maxSpeed) {
            Manipulator.nBuilderFlightMaxMoveSpeed(this.mNativeBuilder, maxSpeed);
            return this;
        }

        public Builder flightSpeedSteps(int steps) {
            Manipulator.nBuilderFlightSpeedSteps(this.mNativeBuilder, steps);
            return this;
        }

        public Builder flightPanSpeed(float x, float y) {
            Manipulator.nBuilderFlightPanSpeed(this.mNativeBuilder, x, y);
            return this;
        }

        public Builder flightMoveDamping(float damping) {
            Manipulator.nBuilderFlightMoveDamping(this.mNativeBuilder, damping);
            return this;
        }

        @NonNull
        public Builder groundPlane(float a, float b, float c, float d) {
            Manipulator.nBuilderGroundPlane(this.mNativeBuilder, a, b, c, d);
            return this;
        }

        @NonNull
        public Manipulator build(Mode mode) {
            long nativeManipulator = Manipulator.nBuilderBuild(this.mNativeBuilder, mode.ordinal());
            if (nativeManipulator == 0L) {
                throw new IllegalStateException("Couldn't create Manipulator");
            }
            return new Manipulator(nativeManipulator);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    Manipulator.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum Key {
        FORWARD,
        LEFT,
        BACKWARD,
        RIGHT,
        UP,
        DOWN;

    }

    public static enum Fov {
        VERTICAL,
        HORIZONTAL;

    }

    public static enum Mode {
        ORBIT,
        MAP,
        FREE_FLIGHT;

    }
}

