/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha.stub;

import com.google.analytics.data.v1alpha.AlphaAnalyticsDataClient;
import com.google.analytics.data.v1alpha.AudienceList;
import com.google.analytics.data.v1alpha.AudienceListMetadata;
import com.google.analytics.data.v1alpha.CreateAudienceListRequest;
import com.google.analytics.data.v1alpha.CreateRecurringAudienceListRequest;
import com.google.analytics.data.v1alpha.GetAudienceListRequest;
import com.google.analytics.data.v1alpha.GetRecurringAudienceListRequest;
import com.google.analytics.data.v1alpha.ListAudienceListsRequest;
import com.google.analytics.data.v1alpha.ListAudienceListsResponse;
import com.google.analytics.data.v1alpha.ListRecurringAudienceListsRequest;
import com.google.analytics.data.v1alpha.ListRecurringAudienceListsResponse;
import com.google.analytics.data.v1alpha.QueryAudienceListRequest;
import com.google.analytics.data.v1alpha.QueryAudienceListResponse;
import com.google.analytics.data.v1alpha.RecurringAudienceList;
import com.google.analytics.data.v1alpha.RunFunnelReportRequest;
import com.google.analytics.data.v1alpha.RunFunnelReportResponse;
import com.google.analytics.data.v1alpha.SheetExportAudienceListRequest;
import com.google.analytics.data.v1alpha.SheetExportAudienceListResponse;
import com.google.analytics.data.v1alpha.stub.AlphaAnalyticsDataStub;
import com.google.analytics.data.v1alpha.stub.GrpcAlphaAnalyticsDataStub;
import com.google.analytics.data.v1alpha.stub.HttpJsonAlphaAnalyticsDataStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AlphaAnalyticsDataStubSettings
extends StubSettings<AlphaAnalyticsDataStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/analytics").add((Object)"https://www.googleapis.com/auth/analytics.readonly").add((Object)"https://www.googleapis.com/auth/drive").add((Object)"https://www.googleapis.com/auth/drive.file").add((Object)"https://www.googleapis.com/auth/spreadsheets").build();
    private final UnaryCallSettings<RunFunnelReportRequest, RunFunnelReportResponse> runFunnelReportSettings;
    private final UnaryCallSettings<CreateAudienceListRequest, Operation> createAudienceListSettings;
    private final OperationCallSettings<CreateAudienceListRequest, AudienceList, AudienceListMetadata> createAudienceListOperationSettings;
    private final UnaryCallSettings<QueryAudienceListRequest, QueryAudienceListResponse> queryAudienceListSettings;
    private final UnaryCallSettings<SheetExportAudienceListRequest, SheetExportAudienceListResponse> sheetExportAudienceListSettings;
    private final UnaryCallSettings<GetAudienceListRequest, AudienceList> getAudienceListSettings;
    private final PagedCallSettings<ListAudienceListsRequest, ListAudienceListsResponse, AlphaAnalyticsDataClient.ListAudienceListsPagedResponse> listAudienceListsSettings;
    private final UnaryCallSettings<CreateRecurringAudienceListRequest, RecurringAudienceList> createRecurringAudienceListSettings;
    private final UnaryCallSettings<GetRecurringAudienceListRequest, RecurringAudienceList> getRecurringAudienceListSettings;
    private final PagedCallSettings<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse> listRecurringAudienceListsSettings;
    private static final PagedListDescriptor<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList> LIST_AUDIENCE_LISTS_PAGE_STR_DESC = new PagedListDescriptor<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList>(){

        public String emptyToken() {
            return "";
        }

        public ListAudienceListsRequest injectToken(ListAudienceListsRequest payload, String token) {
            return ListAudienceListsRequest.newBuilder((ListAudienceListsRequest)payload).setPageToken(token).build();
        }

        public ListAudienceListsRequest injectPageSize(ListAudienceListsRequest payload, int pageSize) {
            return ListAudienceListsRequest.newBuilder((ListAudienceListsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAudienceListsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAudienceListsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AudienceList> extractResources(ListAudienceListsResponse payload) {
            return payload.getAudienceListsList() == null ? ImmutableList.of() : payload.getAudienceListsList();
        }
    };
    private static final PagedListDescriptor<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, RecurringAudienceList> LIST_RECURRING_AUDIENCE_LISTS_PAGE_STR_DESC = new PagedListDescriptor<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, RecurringAudienceList>(){

        public String emptyToken() {
            return "";
        }

        public ListRecurringAudienceListsRequest injectToken(ListRecurringAudienceListsRequest payload, String token) {
            return ListRecurringAudienceListsRequest.newBuilder((ListRecurringAudienceListsRequest)payload).setPageToken(token).build();
        }

        public ListRecurringAudienceListsRequest injectPageSize(ListRecurringAudienceListsRequest payload, int pageSize) {
            return ListRecurringAudienceListsRequest.newBuilder((ListRecurringAudienceListsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRecurringAudienceListsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRecurringAudienceListsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RecurringAudienceList> extractResources(ListRecurringAudienceListsResponse payload) {
            return payload.getRecurringAudienceListsList() == null ? ImmutableList.of() : payload.getRecurringAudienceListsList();
        }
    };
    private static final PagedListResponseFactory<ListAudienceListsRequest, ListAudienceListsResponse, AlphaAnalyticsDataClient.ListAudienceListsPagedResponse> LIST_AUDIENCE_LISTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAudienceListsRequest, ListAudienceListsResponse, AlphaAnalyticsDataClient.ListAudienceListsPagedResponse>(){

        public ApiFuture<AlphaAnalyticsDataClient.ListAudienceListsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAudienceListsRequest, ListAudienceListsResponse> callable, ListAudienceListsRequest request, ApiCallContext context, ApiFuture<ListAudienceListsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUDIENCE_LISTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlphaAnalyticsDataClient.ListAudienceListsPagedResponse.createAsync((PageContext<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse> LIST_RECURRING_AUDIENCE_LISTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse>(){

        public ApiFuture<AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse> callable, ListRecurringAudienceListsRequest request, ApiCallContext context, ApiFuture<ListRecurringAudienceListsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RECURRING_AUDIENCE_LISTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse.createAsync((PageContext<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, RecurringAudienceList>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<RunFunnelReportRequest, RunFunnelReportResponse> runFunnelReportSettings() {
        return this.runFunnelReportSettings;
    }

    public UnaryCallSettings<CreateAudienceListRequest, Operation> createAudienceListSettings() {
        return this.createAudienceListSettings;
    }

    public OperationCallSettings<CreateAudienceListRequest, AudienceList, AudienceListMetadata> createAudienceListOperationSettings() {
        return this.createAudienceListOperationSettings;
    }

    public UnaryCallSettings<QueryAudienceListRequest, QueryAudienceListResponse> queryAudienceListSettings() {
        return this.queryAudienceListSettings;
    }

    public UnaryCallSettings<SheetExportAudienceListRequest, SheetExportAudienceListResponse> sheetExportAudienceListSettings() {
        return this.sheetExportAudienceListSettings;
    }

    public UnaryCallSettings<GetAudienceListRequest, AudienceList> getAudienceListSettings() {
        return this.getAudienceListSettings;
    }

    public PagedCallSettings<ListAudienceListsRequest, ListAudienceListsResponse, AlphaAnalyticsDataClient.ListAudienceListsPagedResponse> listAudienceListsSettings() {
        return this.listAudienceListsSettings;
    }

    public UnaryCallSettings<CreateRecurringAudienceListRequest, RecurringAudienceList> createRecurringAudienceListSettings() {
        return this.createRecurringAudienceListSettings;
    }

    public UnaryCallSettings<GetRecurringAudienceListRequest, RecurringAudienceList> getRecurringAudienceListSettings() {
        return this.getRecurringAudienceListSettings;
    }

    public PagedCallSettings<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse> listRecurringAudienceListsSettings() {
        return this.listRecurringAudienceListsSettings;
    }

    public AlphaAnalyticsDataStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAlphaAnalyticsDataStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAlphaAnalyticsDataStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "analyticsdata";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "analyticsdata.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "analyticsdata.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AlphaAnalyticsDataStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AlphaAnalyticsDataStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AlphaAnalyticsDataStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AlphaAnalyticsDataStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AlphaAnalyticsDataStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.runFunnelReportSettings = settingsBuilder.runFunnelReportSettings().build();
        this.createAudienceListSettings = settingsBuilder.createAudienceListSettings().build();
        this.createAudienceListOperationSettings = settingsBuilder.createAudienceListOperationSettings().build();
        this.queryAudienceListSettings = settingsBuilder.queryAudienceListSettings().build();
        this.sheetExportAudienceListSettings = settingsBuilder.sheetExportAudienceListSettings().build();
        this.getAudienceListSettings = settingsBuilder.getAudienceListSettings().build();
        this.listAudienceListsSettings = settingsBuilder.listAudienceListsSettings().build();
        this.createRecurringAudienceListSettings = settingsBuilder.createRecurringAudienceListSettings().build();
        this.getRecurringAudienceListSettings = settingsBuilder.getRecurringAudienceListSettings().build();
        this.listRecurringAudienceListsSettings = settingsBuilder.listRecurringAudienceListsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AlphaAnalyticsDataStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<RunFunnelReportRequest, RunFunnelReportResponse> runFunnelReportSettings;
        private final UnaryCallSettings.Builder<CreateAudienceListRequest, Operation> createAudienceListSettings;
        private final OperationCallSettings.Builder<CreateAudienceListRequest, AudienceList, AudienceListMetadata> createAudienceListOperationSettings;
        private final UnaryCallSettings.Builder<QueryAudienceListRequest, QueryAudienceListResponse> queryAudienceListSettings;
        private final UnaryCallSettings.Builder<SheetExportAudienceListRequest, SheetExportAudienceListResponse> sheetExportAudienceListSettings;
        private final UnaryCallSettings.Builder<GetAudienceListRequest, AudienceList> getAudienceListSettings;
        private final PagedCallSettings.Builder<ListAudienceListsRequest, ListAudienceListsResponse, AlphaAnalyticsDataClient.ListAudienceListsPagedResponse> listAudienceListsSettings;
        private final UnaryCallSettings.Builder<CreateRecurringAudienceListRequest, RecurringAudienceList> createRecurringAudienceListSettings;
        private final UnaryCallSettings.Builder<GetRecurringAudienceListRequest, RecurringAudienceList> getRecurringAudienceListSettings;
        private final PagedCallSettings.Builder<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse> listRecurringAudienceListsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.runFunnelReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAudienceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAudienceListOperationSettings = OperationCallSettings.newBuilder();
            this.queryAudienceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sheetExportAudienceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAudienceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAudienceListsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUDIENCE_LISTS_PAGE_STR_FACT);
            this.createRecurringAudienceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRecurringAudienceListSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRecurringAudienceListsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RECURRING_AUDIENCE_LISTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.runFunnelReportSettings, this.createAudienceListSettings, this.queryAudienceListSettings, this.sheetExportAudienceListSettings, this.getAudienceListSettings, this.listAudienceListsSettings, this.createRecurringAudienceListSettings, this.getRecurringAudienceListSettings, this.listRecurringAudienceListsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AlphaAnalyticsDataStubSettings settings) {
            super((StubSettings)settings);
            this.runFunnelReportSettings = settings.runFunnelReportSettings.toBuilder();
            this.createAudienceListSettings = settings.createAudienceListSettings.toBuilder();
            this.createAudienceListOperationSettings = settings.createAudienceListOperationSettings.toBuilder();
            this.queryAudienceListSettings = settings.queryAudienceListSettings.toBuilder();
            this.sheetExportAudienceListSettings = settings.sheetExportAudienceListSettings.toBuilder();
            this.getAudienceListSettings = settings.getAudienceListSettings.toBuilder();
            this.listAudienceListsSettings = settings.listAudienceListsSettings.toBuilder();
            this.createRecurringAudienceListSettings = settings.createRecurringAudienceListSettings.toBuilder();
            this.getRecurringAudienceListSettings = settings.getRecurringAudienceListSettings.toBuilder();
            this.listRecurringAudienceListsSettings = settings.listRecurringAudienceListsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.runFunnelReportSettings, this.createAudienceListSettings, this.queryAudienceListSettings, this.sheetExportAudienceListSettings, this.getAudienceListSettings, this.listAudienceListsSettings, this.createRecurringAudienceListSettings, this.getRecurringAudienceListSettings, this.listRecurringAudienceListsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AlphaAnalyticsDataStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AlphaAnalyticsDataStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AlphaAnalyticsDataStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AlphaAnalyticsDataStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AlphaAnalyticsDataStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AlphaAnalyticsDataStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AlphaAnalyticsDataStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AlphaAnalyticsDataStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.runFunnelReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createAudienceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.queryAudienceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.sheetExportAudienceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAudienceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAudienceListsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRecurringAudienceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRecurringAudienceListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRecurringAudienceListsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAudienceListOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AudienceList.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AudienceListMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<RunFunnelReportRequest, RunFunnelReportResponse> runFunnelReportSettings() {
            return this.runFunnelReportSettings;
        }

        public UnaryCallSettings.Builder<CreateAudienceListRequest, Operation> createAudienceListSettings() {
            return this.createAudienceListSettings;
        }

        public OperationCallSettings.Builder<CreateAudienceListRequest, AudienceList, AudienceListMetadata> createAudienceListOperationSettings() {
            return this.createAudienceListOperationSettings;
        }

        public UnaryCallSettings.Builder<QueryAudienceListRequest, QueryAudienceListResponse> queryAudienceListSettings() {
            return this.queryAudienceListSettings;
        }

        public UnaryCallSettings.Builder<SheetExportAudienceListRequest, SheetExportAudienceListResponse> sheetExportAudienceListSettings() {
            return this.sheetExportAudienceListSettings;
        }

        public UnaryCallSettings.Builder<GetAudienceListRequest, AudienceList> getAudienceListSettings() {
            return this.getAudienceListSettings;
        }

        public PagedCallSettings.Builder<ListAudienceListsRequest, ListAudienceListsResponse, AlphaAnalyticsDataClient.ListAudienceListsPagedResponse> listAudienceListsSettings() {
            return this.listAudienceListsSettings;
        }

        public UnaryCallSettings.Builder<CreateRecurringAudienceListRequest, RecurringAudienceList> createRecurringAudienceListSettings() {
            return this.createRecurringAudienceListSettings;
        }

        public UnaryCallSettings.Builder<GetRecurringAudienceListRequest, RecurringAudienceList> getRecurringAudienceListSettings() {
            return this.getRecurringAudienceListSettings;
        }

        public PagedCallSettings.Builder<ListRecurringAudienceListsRequest, ListRecurringAudienceListsResponse, AlphaAnalyticsDataClient.ListRecurringAudienceListsPagedResponse> listRecurringAudienceListsSettings() {
            return this.listRecurringAudienceListsSettings;
        }

        public AlphaAnalyticsDataStubSettings build() throws IOException {
            return new AlphaAnalyticsDataStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

