/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.analytics.data.v1alpha.AlphaAnalyticsDataSettings;
import com.google.analytics.data.v1alpha.AudienceList;
import com.google.analytics.data.v1alpha.AudienceListMetadata;
import com.google.analytics.data.v1alpha.AudienceListName;
import com.google.analytics.data.v1alpha.CreateAudienceListRequest;
import com.google.analytics.data.v1alpha.GetAudienceListRequest;
import com.google.analytics.data.v1alpha.ListAudienceListsRequest;
import com.google.analytics.data.v1alpha.ListAudienceListsResponse;
import com.google.analytics.data.v1alpha.PropertyName;
import com.google.analytics.data.v1alpha.QueryAudienceListRequest;
import com.google.analytics.data.v1alpha.QueryAudienceListResponse;
import com.google.analytics.data.v1alpha.RunFunnelReportRequest;
import com.google.analytics.data.v1alpha.RunFunnelReportResponse;
import com.google.analytics.data.v1alpha.stub.AlphaAnalyticsDataStub;
import com.google.analytics.data.v1alpha.stub.AlphaAnalyticsDataStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AlphaAnalyticsDataClient
implements BackgroundResource {
    private final AlphaAnalyticsDataSettings settings;
    private final AlphaAnalyticsDataStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AlphaAnalyticsDataClient create() throws IOException {
        return AlphaAnalyticsDataClient.create(AlphaAnalyticsDataSettings.newBuilder().build());
    }

    public static final AlphaAnalyticsDataClient create(AlphaAnalyticsDataSettings settings) throws IOException {
        return new AlphaAnalyticsDataClient(settings);
    }

    public static final AlphaAnalyticsDataClient create(AlphaAnalyticsDataStub stub) {
        return new AlphaAnalyticsDataClient(stub);
    }

    protected AlphaAnalyticsDataClient(AlphaAnalyticsDataSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AlphaAnalyticsDataStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AlphaAnalyticsDataClient(AlphaAnalyticsDataStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AlphaAnalyticsDataSettings getSettings() {
        return this.settings;
    }

    public AlphaAnalyticsDataStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final RunFunnelReportResponse runFunnelReport(RunFunnelReportRequest request) {
        return (RunFunnelReportResponse)this.runFunnelReportCallable().call((Object)request);
    }

    public final UnaryCallable<RunFunnelReportRequest, RunFunnelReportResponse> runFunnelReportCallable() {
        return this.stub.runFunnelReportCallable();
    }

    public final OperationFuture<AudienceList, AudienceListMetadata> createAudienceListAsync(PropertyName parent, AudienceList audienceList) {
        CreateAudienceListRequest request = CreateAudienceListRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAudienceList(audienceList).build();
        return this.createAudienceListAsync(request);
    }

    public final OperationFuture<AudienceList, AudienceListMetadata> createAudienceListAsync(String parent, AudienceList audienceList) {
        CreateAudienceListRequest request = CreateAudienceListRequest.newBuilder().setParent(parent).setAudienceList(audienceList).build();
        return this.createAudienceListAsync(request);
    }

    public final OperationFuture<AudienceList, AudienceListMetadata> createAudienceListAsync(CreateAudienceListRequest request) {
        return this.createAudienceListOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAudienceListRequest, AudienceList, AudienceListMetadata> createAudienceListOperationCallable() {
        return this.stub.createAudienceListOperationCallable();
    }

    public final UnaryCallable<CreateAudienceListRequest, Operation> createAudienceListCallable() {
        return this.stub.createAudienceListCallable();
    }

    public final QueryAudienceListResponse queryAudienceList(String name) {
        QueryAudienceListRequest request = QueryAudienceListRequest.newBuilder().setName(name).build();
        return this.queryAudienceList(request);
    }

    public final QueryAudienceListResponse queryAudienceList(QueryAudienceListRequest request) {
        return (QueryAudienceListResponse)this.queryAudienceListCallable().call((Object)request);
    }

    public final UnaryCallable<QueryAudienceListRequest, QueryAudienceListResponse> queryAudienceListCallable() {
        return this.stub.queryAudienceListCallable();
    }

    public final AudienceList getAudienceList(AudienceListName name) {
        GetAudienceListRequest request = GetAudienceListRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAudienceList(request);
    }

    public final AudienceList getAudienceList(String name) {
        GetAudienceListRequest request = GetAudienceListRequest.newBuilder().setName(name).build();
        return this.getAudienceList(request);
    }

    public final AudienceList getAudienceList(GetAudienceListRequest request) {
        return (AudienceList)this.getAudienceListCallable().call((Object)request);
    }

    public final UnaryCallable<GetAudienceListRequest, AudienceList> getAudienceListCallable() {
        return this.stub.getAudienceListCallable();
    }

    public final ListAudienceListsPagedResponse listAudienceLists(PropertyName parent) {
        ListAudienceListsRequest request = ListAudienceListsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAudienceLists(request);
    }

    public final ListAudienceListsPagedResponse listAudienceLists(String parent) {
        ListAudienceListsRequest request = ListAudienceListsRequest.newBuilder().setParent(parent).build();
        return this.listAudienceLists(request);
    }

    public final ListAudienceListsPagedResponse listAudienceLists(ListAudienceListsRequest request) {
        return (ListAudienceListsPagedResponse)((Object)this.listAudienceListsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAudienceListsRequest, ListAudienceListsPagedResponse> listAudienceListsPagedCallable() {
        return this.stub.listAudienceListsPagedCallable();
    }

    public final UnaryCallable<ListAudienceListsRequest, ListAudienceListsResponse> listAudienceListsCallable() {
        return this.stub.listAudienceListsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAudienceListsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList, ListAudienceListsPage, ListAudienceListsFixedSizeCollection> {
        private ListAudienceListsFixedSizeCollection(List<ListAudienceListsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAudienceListsFixedSizeCollection createEmptyCollection() {
            return new ListAudienceListsFixedSizeCollection(null, 0);
        }

        protected ListAudienceListsFixedSizeCollection createCollection(List<ListAudienceListsPage> pages, int collectionSize) {
            return new ListAudienceListsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAudienceListsPage
    extends AbstractPage<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList, ListAudienceListsPage> {
        private ListAudienceListsPage(PageContext<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList> context, ListAudienceListsResponse response) {
            super(context, (Object)response);
        }

        private static ListAudienceListsPage createEmptyPage() {
            return new ListAudienceListsPage(null, null);
        }

        protected ListAudienceListsPage createPage(PageContext<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList> context, ListAudienceListsResponse response) {
            return new ListAudienceListsPage(context, response);
        }

        public ApiFuture<ListAudienceListsPage> createPageAsync(PageContext<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList> context, ApiFuture<ListAudienceListsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAudienceListsPagedResponse
    extends AbstractPagedListResponse<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList, ListAudienceListsPage, ListAudienceListsFixedSizeCollection> {
        public static ApiFuture<ListAudienceListsPagedResponse> createAsync(PageContext<ListAudienceListsRequest, ListAudienceListsResponse, AudienceList> context, ApiFuture<ListAudienceListsResponse> futureResponse) {
            ApiFuture<ListAudienceListsPage> futurePage = ListAudienceListsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAudienceListsPagedResponse((ListAudienceListsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAudienceListsPagedResponse(ListAudienceListsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAudienceListsFixedSizeCollection.createEmptyCollection());
        }
    }
}

