/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.agents.BaseAgent;
import com.google.adk.events.Event;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.Session;
import com.google.adk.web.AgentGraphGenerator;
import com.google.adk.web.AgentLoader;
import com.google.adk.web.dto.GraphResponse;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import io.reactivex.rxjava3.core.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class GraphController {
    private static final Logger log = LoggerFactory.getLogger(GraphController.class);
    private final BaseSessionService sessionService;
    private final AgentLoader agentProvider;

    @Autowired
    public GraphController(BaseSessionService sessionService, AgentLoader agentProvider) {
        this.sessionService = sessionService;
        this.agentProvider = agentProvider;
    }

    private Session findSessionOrThrow(String appName, String userId, String sessionId) {
        Maybe maybeSession = this.sessionService.getSession(appName, userId, sessionId, Optional.empty());
        Session session = (Session)maybeSession.blockingGet();
        if (session == null) {
            log.warn("Session not found for appName={}, userId={}, sessionId={}", new Object[]{appName, userId, sessionId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, String.format("Session not found: appName=%s, userId=%s, sessionId=%s", appName, userId, sessionId));
        }
        if (!Objects.equals(session.appName(), appName) || !Objects.equals(session.userId(), userId)) {
            log.warn("Session ID {} found but appName/userId mismatch (Expected: {}/{}, Found: {}/{}) - Treating as not found.", new Object[]{sessionId, appName, userId, session.appName(), session.userId()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session found but belongs to a different app/user.");
        }
        log.debug("Found session: {}", (Object)sessionId);
        return session;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/events/{eventId}/graph"})
    public ResponseEntity<GraphResponse> getEventGraph(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String eventId) {
        BaseAgent currentAppAgent;
        log.info("Request received for GET /apps/{}/users/{}/sessions/{}/events/{}/graph", new Object[]{appName, userId, sessionId, eventId});
        try {
            currentAppAgent = this.agentProvider.loadAgent(appName);
        }
        catch (NoSuchElementException e2) {
            log.warn("Agent app '{}' not found for graph generation.", (Object)appName);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)new GraphResponse("Agent app not found: " + appName));
        }
        catch (IllegalStateException e3) {
            log.warn("Agent app '{}' failed to load for graph generation: {}", (Object)appName, (Object)e3.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new GraphResponse("Agent app failed to load: " + appName));
        }
        Session session = this.findSessionOrThrow(appName, userId, sessionId);
        Event event = session.events().stream().filter(e -> Objects.equals(e.id(), eventId)).findFirst().orElse(null);
        if (event == null) {
            log.warn("Event {} not found in session {}", (Object)eventId, (Object)sessionId);
            return ResponseEntity.ok((Object)new GraphResponse(null));
        }
        log.debug("Found event {} for graph generation.", (Object)eventId);
        ArrayList<List<String>> highlightPairs = new ArrayList<List<String>>();
        String eventAuthor = event.author();
        ImmutableList functionCalls = event.functionCalls();
        ImmutableList functionResponses = event.functionResponses();
        if (!functionCalls.isEmpty()) {
            log.debug("Processing {} function calls for highlighting.", (Object)functionCalls.size());
            for (FunctionCall fc : functionCalls) {
                Optional toolName = fc.name();
                if (!toolName.isPresent() || ((String)toolName.get()).isEmpty()) continue;
                highlightPairs.add((List<String>)ImmutableList.of((Object)eventAuthor, (Object)((String)toolName.get())));
                log.trace("Adding function call highlight: {} -> {}", (Object)eventAuthor, toolName.get());
            }
        } else if (!functionResponses.isEmpty()) {
            log.debug("Processing {} function responses for highlighting.", (Object)functionResponses.size());
            for (FunctionResponse fr : functionResponses) {
                Optional toolName = fr.name();
                if (!toolName.isPresent() || ((String)toolName.get()).isEmpty()) continue;
                highlightPairs.add((List<String>)ImmutableList.of((Object)((String)toolName.get()), (Object)eventAuthor));
                log.trace("Adding function response highlight: {} -> {}", toolName.get(), (Object)eventAuthor);
            }
        } else {
            log.debug("Processing simple event, highlighting author: {}", (Object)eventAuthor);
            highlightPairs.add((List<String>)ImmutableList.of((Object)eventAuthor, (Object)eventAuthor));
        }
        Optional<String> dotSourceOpt = AgentGraphGenerator.getAgentGraphDotSource(currentAppAgent, highlightPairs);
        if (dotSourceOpt.isPresent()) {
            log.debug("Successfully generated graph DOT source for event {}", (Object)eventId);
            return ResponseEntity.ok((Object)new GraphResponse(dotSourceOpt.get()));
        }
        log.warn("Failed to generate graph DOT source for event {} with agent {}", (Object)eventId, (Object)currentAppAgent.name());
        return ResponseEntity.ok((Object)new GraphResponse("Could not generate graph for this event."));
    }
}

