/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.config;

import com.google.adk.web.service.ApiServerSpanExporter;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenTelemetryConfig {
    private static final Logger otelLog = LoggerFactory.getLogger(OpenTelemetryConfig.class);

    @Bean
    public ApiServerSpanExporter apiServerSpanExporter() {
        return new ApiServerSpanExporter();
    }

    @Bean(destroyMethod="shutdown")
    public SdkTracerProvider sdkTracerProvider(ApiServerSpanExporter apiServerSpanExporter) {
        otelLog.debug("Configuring SdkTracerProvider with ApiServerSpanExporter.");
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"adk-web-server")));
        return SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)apiServerSpanExporter)).setResource(resource).build();
    }

    @Bean
    public OpenTelemetry openTelemetrySdk(SdkTracerProvider sdkTracerProvider) {
        otelLog.debug("Configuring OpenTelemetrySdk and registering globally.");
        try {
            GlobalOpenTelemetry.get();
            otelLog.debug("OpenTelemetry already registered globally, creating non-global instance.");
            return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).build();
        }
        catch (IllegalStateException e) {
            otelLog.debug("Registering OpenTelemetry globally.");
            OpenTelemetrySdk otelSdk = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).buildAndRegisterGlobal();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((OpenTelemetrySdk)otelSdk).close()));
            return otelSdk;
        }
    }
}

