/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web;

import com.google.adk.agents.BaseAgent;
import com.google.adk.web.AgentLoader;
import com.google.adk.web.config.AgentLoadingProperties;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service(value="agentLoader")
@Primary
@ConditionalOnProperty(name={"adk.agents.loader"}, havingValue="compiled", matchIfMissing=true)
@ThreadSafe
public class CompiledAgentLoader
implements AgentLoader {
    private static final Logger logger = LoggerFactory.getLogger(CompiledAgentLoader.class);
    private final AgentLoadingProperties properties;
    private final ImmutableMap<String, Supplier<BaseAgent>> agentSuppliers;

    public CompiledAgentLoader(AgentLoadingProperties properties) {
        this.properties = properties;
        logger.info("Initializing CompiledAgentLoader for path-based agents");
        HashMap<String, Supplier<BaseAgent>> allAgents = new HashMap<String, Supplier<BaseAgent>>();
        if (properties.getSourceDir() != null && !properties.getSourceDir().isEmpty()) {
            this.loadPathBasedAgents(allAgents);
        } else {
            logger.warn("No source directory configured (adk.agents.source-dir). No agents will be available.");
        }
        this.agentSuppliers = ImmutableMap.copyOf(allAgents);
        logger.info("CompiledAgentLoader initialized with {} agents: {}", (Object)this.agentSuppliers.size(), (Object)this.agentSuppliers.keySet());
    }

    @Override
    @Nonnull
    public ImmutableList<String> listAgents() {
        return ImmutableList.copyOf((Collection)this.agentSuppliers.keySet());
    }

    @Override
    public BaseAgent loadAgent(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent name cannot be null or empty");
        }
        Supplier supplier = (Supplier)this.agentSuppliers.get((Object)name);
        if (supplier == null) {
            logger.warn("Agent not found: {}. Available agents: {}", (Object)name, (Object)this.agentSuppliers.keySet());
            throw new NoSuchElementException("Agent not found: " + name);
        }
        try {
            BaseAgent agent = (BaseAgent)supplier.get();
            logger.debug("Successfully loaded agent: {}", (Object)name);
            return agent;
        }
        catch (Exception e) {
            logger.error("Failed to load agent: {}", (Object)name, (Object)e);
            throw new IllegalStateException("Agent exists but failed to load: " + name, e);
        }
    }

    private void loadPathBasedAgents(Map<String, Supplier<BaseAgent>> agents) {
        Path sourceDir = Paths.get(this.properties.getSourceDir(), new String[0]);
        if (!Files.isDirectory(sourceDir, new LinkOption[0])) {
            logger.warn("Agent source directory does not exist: {}. Skipping path-based agent loading.", (Object)sourceDir);
            return;
        }
        logger.info("Scanning for agent units in: {}", (Object)sourceDir);
        Path targetClasses = sourceDir.resolve("target/classes");
        if (Files.exists(targetClasses, new LinkOption[0]) && Files.isDirectory(targetClasses, new LinkOption[0])) {
            logger.info("Found Maven project structure, scanning target/classes: {}", (Object)targetClasses);
            this.loadAgentsFromDirectory(targetClasses, agents);
        }
        try (Stream<Path> entries = Files.list(sourceDir);){
            entries.forEach(entry -> {
                String agentUnitName;
                if (Files.isDirectory(entry, new LinkOption[0]) && !"target".equals(agentUnitName = entry.getFileName().toString())) {
                    this.loadAgentUnit((Path)entry, agentUnitName, agents);
                }
            });
        }
        catch (IOException e) {
            logger.error("IO error loading path-based agents from: {}", (Object)sourceDir, (Object)e);
        }
        catch (SecurityException e) {
            logger.error("Security error accessing path-based agents from: {}", (Object)sourceDir, (Object)e);
        }
        catch (InvalidPathException e) {
            logger.error("Invalid path error loading path-based agents from: {}", (Object)sourceDir, (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error loading path-based agents from: {}", (Object)sourceDir, (Object)e);
        }
        logger.info("Completed path-based agent discovery. Found {} total agents", (Object)agents.size());
    }

    private void loadAgentUnit(Path agentUnitDir, String unitName, Map<String, Supplier<BaseAgent>> agents) {
        try {
            this.loadAgentsFromDirectory(agentUnitDir, agents);
        }
        catch (Exception e) {
            logger.error("Error processing agent unit: {}", (Object)unitName, (Object)e);
        }
    }

    private void loadAgentsFromDirectory(Path directory, Map<String, Supplier<BaseAgent>> agents) {
        try {
            String agentUnitName = directory.getFileName().toString();
            Path classesDir = directory.toString().endsWith("classes") || this.hasClassFiles(directory) ? directory : this.findBuildOutputDir(directory);
            try (URLClassLoader classLoader = new URLClassLoader(new URL[]{classesDir.toUri().toURL()}, CompiledAgentLoader.class.getClassLoader());
                 Stream<Path> classFiles = Files.walk(classesDir, new FileVisitOption[0]);){
                classFiles.filter(p -> p.toString().endsWith(".class")).forEach(classFile -> {
                    try {
                        String relativePath = classesDir.relativize((Path)classFile).toString();
                        String className = relativePath.substring(0, relativePath.length() - ".class".length()).replace(File.separatorChar, '.');
                        this.loadAgentFromClass(className, classLoader, agentUnitName, agents);
                    }
                    catch (Exception e) {
                        logger.warn("Error loading agent from class file: {}", classFile, (Object)e);
                    }
                });
            }
        }
        catch (IOException e) {
            logger.error("IO error loading agents from directory: {}", (Object)directory, (Object)e);
        }
        catch (SecurityException e) {
            logger.error("Security error accessing directory: {}", (Object)directory, (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error loading agents from directory: {}", (Object)directory, (Object)e);
        }
    }

    private boolean hasClassFiles(Path directory) {
        boolean bl;
        block9: {
            Stream<Path> files = Files.list(directory);
            try {
                bl = files.anyMatch(p -> p.toString().endsWith(".class"));
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.debug("IO error checking for class files in directory: {}", (Object)directory, (Object)e);
                    return false;
                }
                catch (SecurityException e) {
                    logger.debug("Security error accessing directory: {}", (Object)directory, (Object)e);
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    private Path findBuildOutputDir(Path directory) {
        for (String buildDir : this.properties.getBuildOutputDirs()) {
            Path candidateDir = directory.resolve(buildDir);
            if (!Files.exists(candidateDir, new LinkOption[0]) || !Files.isDirectory(candidateDir, new LinkOption[0])) continue;
            logger.debug("Found build output directory: {} in {}", (Object)buildDir, (Object)directory);
            return candidateDir;
        }
        logger.debug("No configured build output directories found in {}, using directory itself", (Object)directory);
        return directory;
    }

    private void loadAgentFromClass(String className, ClassLoader classLoader, String unitName, Map<String, Supplier<BaseAgent>> agents) {
        block14: {
            try {
                Field rootAgentField;
                Class<?> loadedClass = classLoader.loadClass(className);
                try {
                    rootAgentField = loadedClass.getField("ROOT_AGENT");
                }
                catch (NoSuchFieldException e) {
                    return;
                }
                if (!Modifier.isStatic(rootAgentField.getModifiers()) || !BaseAgent.class.isAssignableFrom(rootAgentField.getType())) break block14;
                com.google.common.base.Supplier agentSupplier = Suppliers.memoize(() -> {
                    try {
                        BaseAgent agentInstance = (BaseAgent)rootAgentField.get(null);
                        if (agentInstance != null) {
                            logger.info("Loaded path-based agent '{}' from class {} in unit {}", new Object[]{agentInstance.name(), className, unitName});
                            return agentInstance;
                        }
                        logger.warn("ROOT_AGENT field in class {} was null", (Object)className);
                        throw new IllegalStateException("ROOT_AGENT field was null");
                    }
                    catch (IllegalAccessException e) {
                        logger.error("Cannot access ROOT_AGENT field in class {}", (Object)className, (Object)e);
                        throw new RuntimeException("Cannot access ROOT_AGENT field", e);
                    }
                    catch (Exception e) {
                        logger.error("Error initializing agent from class {}", (Object)className, (Object)e);
                        throw new RuntimeException("Agent initialization failed", e);
                    }
                });
                try {
                    BaseAgent tempAgent = (BaseAgent)rootAgentField.get(null);
                    if (tempAgent != null) {
                        String agentName = tempAgent.name();
                        if (agents.containsKey(agentName)) {
                            logger.warn("Found duplicate agent name '{}'. Path-based agent from {} will overwrite existing agent.", (Object)agentName, (Object)unitName);
                        }
                        agents.put(agentName, (Supplier<BaseAgent>)agentSupplier);
                        logger.debug("Registered path-based agent '{}' from class {}", (Object)agentName, (Object)className);
                    }
                }
                catch (IllegalAccessException e) {
                    logger.error("Cannot access ROOT_AGENT field in class {} to get agent name", (Object)className, (Object)e);
                }
                catch (Exception e) {
                    logger.error("Error getting agent name from class {}", (Object)className, (Object)e);
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not load class {} from unit {}", (Object)className, (Object)unitName);
            }
            catch (NoClassDefFoundError e) {
                logger.warn("Class definition error loading {} from unit {}: {}", new Object[]{className, unitName, e.getMessage()});
            }
            catch (LinkageError e) {
                logger.warn("Linkage error loading class {} from unit {}: {}", new Object[]{className, unitName, e.getMessage()});
            }
            catch (SecurityException e) {
                logger.warn("Security error accessing class {} from unit {}: {}", new Object[]{className, unitName, e.getMessage()});
            }
            catch (ClassCastException e) {
                logger.warn("Class {} from unit {} is not a BaseAgent: {}", new Object[]{className, unitName, e.getMessage()});
            }
            catch (Exception e) {
                logger.error("Unexpected error loading agent from class {} in unit {}", new Object[]{className, unitName, e});
            }
        }
    }
}

