/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.BaseAgent;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.artifacts.InMemoryArtifactService;
import com.google.adk.memory.BaseMemoryService;
import com.google.adk.memory.InMemoryMemoryService;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.InMemorySessionService;
import com.google.adk.web.AgentStaticLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
@ConfigurationPropertiesScan
public class AdkWebServer
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AdkWebServer.class);
    @Value(value="${adk.web.ui.dir:#{null}}")
    private String webUiDir;

    @Bean
    public BaseSessionService sessionService() {
        log.info("Using InMemorySessionService");
        return new InMemorySessionService();
    }

    @Bean
    public BaseArtifactService artifactService() {
        log.info("Using InMemoryArtifactService");
        return new InMemoryArtifactService();
    }

    @Bean
    public BaseMemoryService memoryService() {
        log.info("Using InMemoryMemoryService");
        return new InMemoryMemoryService();
    }

    @Bean
    public ObjectMapper objectMapper() {
        return JsonBaseModel.getMapper();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.webUiDir != null && !this.webUiDir.isEmpty()) {
            Object location = this.webUiDir.replace("\\", "/");
            if (!((String)location).startsWith("file:")) {
                location = "file:" + (String)location;
            }
            if (!((String)location).endsWith("/")) {
                location = (String)location + "/";
            }
            log.debug("Mapping URL path /** to static resources at location: {}", location);
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{location}).setCachePeriod(Integer.valueOf(0)).resourceChain(true);
        } else {
            log.debug("System property 'adk.web.ui.dir' or config 'adk.web.ui.dir' is not set. Mapping URL path /** to classpath:/browser/");
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/browser/"}).setCachePeriod(Integer.valueOf(0)).resourceChain(true);
        }
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "/dev-ui");
        registry.addViewController("/dev-ui").setViewName("forward:/index.html");
        registry.addViewController("/dev-ui/").setViewName("forward:/index.html");
    }

    public static void main(String[] args) {
        System.setProperty("org.apache.tomcat.websocket.DEFAULT_BUFFER_SIZE", String.valueOf(0xA00000));
        SpringApplication.run(AdkWebServer.class, (String[])args);
        log.info("AdkWebServer application started successfully.");
    }

    public static void start(final BaseAgent ... agents) {
        System.setProperty("adk.agents.loader", "static");
        SpringApplication app = new SpringApplication(new Class[]{AdkWebServer.class});
        app.addInitializers(new ApplicationContextInitializer[]{new ApplicationContextInitializer<ConfigurableApplicationContext>(){

            public void initialize(ConfigurableApplicationContext context) {
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
                beanFactory.registerSingleton("agentLoader", (Object)new AgentStaticLoader(agents));
            }
        }});
        app.run(new String[0]);
    }
}

