/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.johnjvester.randomizer;

import com.gitlab.johnjvester.randomizer.RandomGenerator;
import com.gitlab.johnjvester.randomizer.Rating;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utility<T> {
    static final Logger logger = LogManager.getLogger(Utility.class);
    static final Integer MAX_MULTIPLIER_LOW = 5;
    static final Integer MAX_MULTIPLIER_MEDIUM = 21;
    static final Integer MAX_MULTIPLIER_HIGH = 210;

    String convertListToString(List<T> thisList, String thisCat) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < thisList.size(); ++i) {
            sb.append(thisList.get(i).toString());
            sb.append(thisCat);
        }
        return sb.toString();
    }

    List<T> convertStringToList(String thisString, String thisCat) {
        ArrayList<String> thisList = new ArrayList<String>();
        int lastCatPointer = 0;
        while (lastCatPointer < thisString.length()) {
            int thisCatPointer = thisString.indexOf(thisCat, lastCatPointer);
            String thisCatValue = thisString.substring(lastCatPointer, thisCatPointer);
            if (thisCatValue != null && thisCatValue.length() > 0) {
                thisList.add(thisCatValue);
            }
            lastCatPointer = thisCatPointer + thisCat.length();
        }
        return thisList;
    }

    Boolean isListSizeValid(List<T> thisList, Integer ratingSize) {
        if (thisList != null && thisList.size() > 0) {
            Integer maxSize = thisList.size() * RandomGenerator.RATING_LEVEL_LOW;
            if (ratingSize == RandomGenerator.RATING_LEVEL_MEDIUM) {
                maxSize = thisList.size() * MAX_MULTIPLIER_MEDIUM;
            } else if (ratingSize == RandomGenerator.RATING_LEVEL_HIGH) {
                maxSize = thisList.size() * MAX_MULTIPLIER_HIGH;
            }
            if (maxSize <= Integer.MAX_VALUE) {
                return true;
            }
            return false;
        }
        return true;
    }

    Integer findValueInMap(Integer value, TreeMap<Integer, Integer> treeMap) {
        logger.debug("begin findValueInMap(" + value + ", treeMap)");
        Map.Entry<Integer, Integer> entry = treeMap.floorEntry(value);
        logger.debug("entry.getValue() = " + entry.getValue());
        return entry.getValue();
    }

    Integer findValueInRatingMap(Integer value, TreeMap<Integer, Rating> treeMap) {
        logger.debug("begin findValueInRatingMap(" + value + ", treeMap)");
        Map.Entry<Integer, Rating> entry = treeMap.floorEntry(value);
        logger.debug("entry.getValue() = " + entry.getValue().getMultiplier());
        return entry.getValue().getMultiplier();
    }

    Integer getMultiplier(int segment, Integer ratingLevel) {
        logger.debug("begin getMultiplier(" + segment + ", " + ratingLevel + ")");
        switch (segment) {
            case 1: {
                return 1;
            }
            case 2: {
                switch (ratingLevel) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
            }
            case 3: {
                switch (ratingLevel) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 6;
                    }
                }
            }
            case 4: {
                switch (ratingLevel) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 10;
                    }
                }
            }
            case 5: {
                switch (ratingLevel) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 15;
                    }
                }
            }
            case 6: {
                switch (ratingLevel) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 21;
                    }
                }
            }
            case 7: {
                switch (ratingLevel) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 6;
                    }
                    case 3: {
                        return 28;
                    }
                }
            }
            case 8: {
                switch (ratingLevel) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 6;
                    }
                    case 3: {
                        return 36;
                    }
                }
            }
            case 9: {
                switch (ratingLevel) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                    case 3: {
                        return 45;
                    }
                }
            }
            case 10: {
                switch (ratingLevel) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 55;
                    }
                }
            }
            case 11: {
                switch (ratingLevel) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 66;
                    }
                }
            }
            case 12: {
                switch (ratingLevel) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 78;
                    }
                }
            }
            case 13: {
                switch (ratingLevel) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 91;
                    }
                }
            }
            case 14: {
                switch (ratingLevel) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 105;
                    }
                }
            }
            case 15: {
                switch (ratingLevel) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 120;
                    }
                }
            }
            case 16: {
                switch (ratingLevel) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 136;
                    }
                }
            }
            case 17: {
                switch (ratingLevel) {
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 153;
                    }
                }
            }
            case 18: {
                switch (ratingLevel) {
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 171;
                    }
                }
            }
            case 19: {
                switch (ratingLevel) {
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 21;
                    }
                    case 3: {
                        return 190;
                    }
                }
            }
            case 20: {
                switch (ratingLevel) {
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 21;
                    }
                    case 3: {
                        return 210;
                    }
                }
            }
        }
        return 1;
    }
}

