/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.johnjvester.randomizer;

import com.gitlab.johnjvester.randomizer.ErrorCode;
import com.gitlab.johnjvester.randomizer.NameFormat;
import com.gitlab.johnjvester.randomizer.RandomData;
import com.gitlab.johnjvester.randomizer.RandomGenerator;
import com.gitlab.johnjvester.randomizer.RandomGeneratorException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomGeneratorData {
    static final Logger logger = LogManager.getLogger(RandomGenerator.class);
    RandomGenerator randomGenerator = new RandomGenerator();

    public List<String> randomizeFullNames(NameFormat nameFormat, Integer returnSize) throws RandomGeneratorException {
        logger.debug("getting random list of " + returnSize + " full names");
        ArrayList<String> fullNames = new ArrayList<String>();
        List<String> firstNames = this.randomGenerator.randomize(this.getFirstNames(returnSize));
        List<String> lastNames = this.randomGenerator.randomize(this.getLastNames(returnSize));
        for (int i = 0; i < returnSize; ++i) {
            String firstName = firstNames.get(i);
            String lastName = lastNames.get(i);
            if (nameFormat != null) {
                if (nameFormat.equals((Object)NameFormat.FIRST_LAST)) {
                    fullNames.add(firstName + " " + lastName);
                    continue;
                }
                if (!nameFormat.equals((Object)NameFormat.LAST_FIRST)) continue;
                fullNames.add(lastName + ", " + firstName);
                continue;
            }
            throw new RandomGeneratorException(ErrorCode.UNKNOWN_NAME_FORMAT, "The nameformat parameter cannot be null.");
        }
        logger.debug("fullNames.size() = " + fullNames.stream());
        return fullNames;
    }

    private List<String> getFirstNames(Integer returnSize) {
        List<String> firstNames = RandomData.getFirstNames();
        logger.debug("returnSize = " + returnSize);
        logger.debug("firstNames.size() = " + firstNames.size());
        if (returnSize > firstNames.size()) {
            double value = returnSize / firstNames.size();
            logger.debug("value = " + value);
            for (int i = 0; i < (int)value; ++i) {
                firstNames.addAll(RandomData.getFirstNames());
            }
        }
        return firstNames.stream().limit(returnSize.intValue()).collect(Collectors.toList());
    }

    private List<String> getLastNames(Integer returnSize) {
        List<String> lastNames = RandomData.getLastNames();
        logger.debug("returnSize = " + returnSize);
        logger.debug("lastNames.size() = " + lastNames.size());
        if (returnSize > lastNames.size()) {
            double value = returnSize / lastNames.size();
            logger.debug("value = " + value);
            for (int i = 0; i < (int)value; ++i) {
                lastNames.addAll(RandomData.getLastNames());
            }
        }
        return lastNames.stream().limit(returnSize.intValue()).collect(Collectors.toList());
    }
}

