/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.johnjvester.randomizer;

import com.gitlab.johnjvester.randomizer.Rating;
import com.gitlab.johnjvester.randomizer.Utility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomGenerator<T> {
    static final Logger logger = LogManager.getLogger(RandomGenerator.class);
    private static final Integer ZERO = new Integer("0");
    private Utility utility = new Utility();
    public static String DEFAULT_DELIMITER = "~~~";
    public static String RATING = "rating";
    public static final int RATING_LEVEL_OFF = new Integer("0");
    public static final int RATING_LEVEL_LOW = new Integer("1");
    public static final int RATING_LEVEL_MEDIUM = new Integer("2");
    public static final int RATING_LEVEL_HIGH = new Integer("3");

    public List<T> randomize(List<T> tList) {
        logger.debug("calling preProcessing(tList, ZERO, false)");
        return this.preProcessing(tList, ZERO, RATING_LEVEL_OFF);
    }

    public List<T> randomize(List<T> tList, Boolean useRating) {
        logger.debug("calling preProcessing(tlist, ZERO, " + useRating + ")");
        return this.preProcessing(tList, ZERO, useRating != false ? RATING_LEVEL_LOW : RATING_LEVEL_OFF);
    }

    public List<T> randomize(List<T> tList, int ratingLevel) {
        logger.debug("calling preProcessing(tlist, ZERO, " + ratingLevel + ")");
        return this.preProcessing(tList, ZERO, ratingLevel);
    }

    public List<T> randomize(List<T> tList, Integer maxResults) {
        logger.debug("calling preProcessing(tList, " + maxResults + ", false)");
        return this.preProcessing(tList, maxResults != null ? maxResults : ZERO, RATING_LEVEL_OFF);
    }

    public List<T> randomize(List<T> tList, Integer maxResults, Boolean useRating) {
        logger.debug("calling preProcessing(tList, " + maxResults + ", " + useRating + ")");
        return this.preProcessing(tList, maxResults != null ? maxResults : ZERO, useRating != false ? RATING_LEVEL_LOW : RATING_LEVEL_OFF);
    }

    public List<T> randomize(List<T> tList, Integer maxResults, int ratingLevel) {
        logger.debug("calling preProcessing(tList, " + maxResults + ", " + ratingLevel + ")");
        return this.preProcessing(tList, maxResults != null ? maxResults : ZERO, ratingLevel);
    }

    public String randomize(String thisString, String thisSeparator) {
        logger.debug("calling convertStringToList(thisString, " + thisSeparator + ")");
        List thisList = this.utility.convertStringToList(thisString, thisSeparator);
        logger.debug("calling convertListToString(preProcessing(thisList, ZERO, false), " + thisSeparator + ")");
        return this.utility.convertListToString(this.preProcessing(thisList, ZERO, RATING_LEVEL_OFF), thisSeparator);
    }

    public String randomize(String thisString, String thisSeparator, Integer maxResults) {
        logger.debug("calling convertStringToList(thisString, " + thisSeparator + ")");
        List thisList = this.utility.convertStringToList(thisString, thisSeparator);
        logger.debug("calling convertListToString(preProcessing(thisList, " + maxResults != null ? maxResults : ZERO + ", false), " + thisSeparator + ")");
        return this.utility.convertListToString(this.preProcessing(thisList, maxResults != null ? maxResults : ZERO, RATING_LEVEL_OFF), thisSeparator);
    }

    private List<T> preProcessing(List<T> tList, Integer maxResults, Integer ratingLevel) {
        logger.debug("begin preProcessing(tList, " + maxResults + ", " + ratingLevel + ")");
        ArrayList<RandomListItem> returnList = new ArrayList<RandomListItem>();
        if (tList != null && tList.size() > 0) {
            logger.debug("tList.size() = " + tList.size());
            if (tList.size() == 1) {
                return tList;
            }
            if (ratingLevel != null && ratingLevel > 0 && !this.utility.isListSizeValid(tList, ratingLevel).booleanValue()) {
                logger.error("The list size being processed (" + tList.size() + ") is too large to include rating functionality.");
                ratingLevel = 0;
            }
            if (maxResults > ZERO) {
                if (maxResults >= tList.size()) {
                    logger.debug("maxResults (" + maxResults + ") is greater than tList.size() (" + tList.size() + ")");
                    this.handleRandomization(this.expandListForRatings(tList, ratingLevel), returnList, ZERO);
                } else {
                    this.handleRandomization(this.expandListForRatings(tList, ratingLevel), returnList, maxResults);
                }
            } else {
                this.handleRandomization(this.expandListForRatings(tList, ratingLevel), returnList, ZERO);
            }
        }
        logger.debug("returnList.size() = " + returnList.size());
        logger.debug("end preProcessing(tList, " + maxResults + ")");
        return this.convertToGenericList(returnList);
    }

    private void handleRandomization(List<RandomListItem> randomListItems, List<RandomListItem> returnList, Integer maxResults) {
        logger.debug("begin handleRandomization(tList, returnList, " + maxResults + ")");
        while (randomListItems.size() > 0 && (maxResults.intValue() == ZERO.intValue() || maxResults > returnList.size())) {
            int listSize = randomListItems.size();
            logger.debug("listSize = " + listSize);
            int winner = 0;
            if (listSize != 1) {
                Random random = new Random();
                winner = random.nextInt(listSize);
            }
            logger.debug("winner = " + winner);
            RandomListItem randomListItem = randomListItems.get(winner);
            returnList.add(randomListItem);
            this.removeSimilarItems(randomListItems, randomListItem.randomInt);
            logger.debug("returnList.size() = " + returnList.size());
            logger.debug("randomListItems.size() = " + randomListItems.size());
        }
        logger.debug("end handleRandomization(tList, returnList, " + maxResults + ")");
    }

    private List<RandomListItem> expandListForRatings(List<T> tList, Integer ratingLevel) {
        logger.debug("begin expandListForRatings(tList, " + ratingLevel + ")");
        TreeMap<Integer, Rating> ratingMap = new TreeMap();
        ArrayList<RandomListItem> newList = new ArrayList<RandomListItem>();
        if (tList != null && tList.size() > 0) {
            if (ratingLevel != null && ratingLevel > 0) {
                ratingMap = this.processRatingMap(tList, ratingLevel);
            }
            for (T tItem : tList) {
                if (ratingLevel != null && ratingLevel > 0) {
                    this.copyListItem(tItem, this.utility.findValueInRatingMap(this.getThisRating(tItem), ratingMap), newList);
                    continue;
                }
                this.copyListItem(tItem, 1, newList);
            }
        }
        return newList;
    }

    private Integer getThisRating(T tItem) {
        Integer rating = 1;
        for (Field field : tItem.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(RATING) || !field.getType().equals(Integer.class)) continue;
            try {
                Object o = field.get(tItem);
                rating = (Integer)o;
                logger.debug(RATING + " = " + rating);
            }
            catch (Exception e) {
                logger.debug("Exception occurred trying to get " + RATING + " field value");
            }
        }
        return rating;
    }

    private void copyListItem(T thisT, Integer rating, List<RandomListItem> newList) {
        int uniqueId = this.getUniqueId(newList);
        for (int i = 0; i < rating; ++i) {
            RandomListItem randomListItem = new RandomListItem(uniqueId, thisT);
            newList.add(randomListItem);
        }
    }

    private int getUniqueId(List<RandomListItem> newList) {
        Random random = new Random();
        int uniqueId = random.nextInt(2147101773);
        boolean uniqueValueFound = true;
        while (uniqueValueFound) {
            uniqueId = random.nextInt(2147101773);
            uniqueValueFound = this.foundInList(uniqueId, newList);
        }
        return uniqueId;
    }

    private boolean foundInList(int uniqueId, List<RandomListItem> newList) {
        return newList.stream().anyMatch(rli -> rli.getRandomInt() == uniqueId);
    }

    private List<T> convertToGenericList(List<RandomListItem> randomListItems) {
        ArrayList<Object> tList = new ArrayList<Object>();
        for (RandomListItem randomListItem : randomListItems) {
            tList.add(randomListItem.thisT);
        }
        return tList;
    }

    private void removeSimilarItems(List<RandomListItem> randomListItems, int thisRandomInt) {
        logger.debug("begin removeSimilarItems(randomListItems, " + thisRandomInt + ")");
        Iterator<RandomListItem> itemIterator = randomListItems.iterator();
        int count = 0;
        while (itemIterator.hasNext()) {
            RandomListItem randomListItem = itemIterator.next();
            if (randomListItem.randomInt != thisRandomInt) continue;
            itemIterator.remove();
            ++count;
        }
        logger.debug("Removed " + count + " instance(s) of " + thisRandomInt);
    }

    private TreeMap<Integer, Rating> processRatingMap(List<T> tList, Integer ratingLevel) {
        logger.debug("begin processRatingMap(tList)");
        TreeMap<Integer, Rating> ratingMap = this.buildRatingMap(tList);
        Integer minimumRating = Collections.min(ratingMap.keySet());
        logger.debug("minimumRating = " + minimumRating);
        Integer maximumRating = Collections.max(ratingMap.keySet());
        logger.debug("maximumRating = " + maximumRating);
        Integer range = maximumRating - minimumRating;
        logger.debug("range = " + range);
        Integer segmentSize = range >= 20 ? Integer.valueOf(range / 20) : Integer.valueOf(1);
        logger.debug("segmentSize = " + segmentSize);
        TreeMap<Integer, Integer> treeMap = this.getMultiplier(minimumRating, segmentSize, ratingLevel);
        for (Map.Entry<Integer, Rating> entry : ratingMap.entrySet()) {
            Rating rating = entry.getValue();
            rating.setMultiplier(this.utility.findValueInMap(rating.getValue(), treeMap));
        }
        return ratingMap;
    }

    private TreeMap<Integer, Rating> buildRatingMap(List<T> tList) {
        logger.debug("begin buildRatingMap(tList)");
        TreeMap<Integer, Rating> returnMap = new TreeMap<Integer, Rating>();
        if (tList != null && tList.size() > 0) {
            for (T tItem : tList) {
                Integer thisRating = this.getThisRating(tItem);
                if (returnMap.containsKey(thisRating)) continue;
                Rating rating = new Rating(thisRating);
                returnMap.put(thisRating, rating);
            }
        }
        return returnMap;
    }

    private TreeMap<Integer, Integer> getMultiplier(Integer startPoint, Integer segmentSize, Integer ratingLevel) {
        logger.debug("begin getMultiplier(" + startPoint + ", " + segmentSize + ")");
        TreeMap<Integer, Integer> returnMap = new TreeMap<Integer, Integer>();
        Integer keyValue = startPoint;
        for (int i = 1; i <= 20; ++i) {
            returnMap.put(keyValue, this.utility.getMultiplier(i, ratingLevel));
            keyValue = keyValue + segmentSize;
        }
        return returnMap;
    }

    private class RandomListItem {
        private int randomInt;
        private T thisT;

        public RandomListItem(int randomInt, T thisT) {
            this.randomInt = randomInt;
            this.thisT = thisT;
        }

        public int getRandomInt() {
            return this.randomInt;
        }

        public T getThisT() {
            return this.thisT;
        }

        public void setRandomInt(int randomInt) {
            this.randomInt = randomInt;
        }

        public void setThisT(T thisT) {
            this.thisT = thisT;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RandomListItem)) {
                return false;
            }
            RandomListItem other = (RandomListItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRandomInt() != other.getRandomInt()) {
                return false;
            }
            Object this$thisT = this.getThisT();
            Object other$thisT = other.getThisT();
            return !(this$thisT == null ? other$thisT != null : !this$thisT.equals(other$thisT));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RandomListItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRandomInt();
            Object $thisT = this.getThisT();
            result = result * 59 + ($thisT == null ? 43 : $thisT.hashCode());
            return result;
        }

        public String toString() {
            return "RandomGenerator.RandomListItem(randomInt=" + this.getRandomInt() + ", thisT=" + this.getThisT() + ")";
        }
    }
}

