/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.johnjvester.randomizer;

import com.gitlab.johnjvester.randomizer.NameFormat;
import com.gitlab.johnjvester.randomizer.RandomGenerator;
import com.gitlab.johnjvester.randomizer.RandomGeneratorData;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class Main {
    static final Logger logger = LogManager.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block40: {
            InputStream is = null;
            RandomGenerator randomGenerator = new RandomGenerator();
            RandomGeneratorData randomGeneratorData = new RandomGeneratorData();
            try {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                is = classloader.getResourceAsStream("properties.yml");
                Yaml yaml = new Yaml();
                Map result = (Map)yaml.load(is);
                String currentVersion = result.get("version").toString();
                logger.debug("currentVersion = " + currentVersion);
                Main.writeMessage("", false);
                Main.writeMessage("RandomGenerator version " + currentVersion, true);
                String returnString = null;
                Integer returnListSize = null;
                if (args != null && (args.length == 1 || args.length == 3 || args.length == 5)) {
                    logger.debug("args.length = " + args.length);
                    for (int i = 0; i < args.length; ++i) {
                        logger.debug("args[" + i + "] = " + args[i]);
                    }
                    if (args.length == 1) {
                        Main.writeMessage("Randomizing string with default delimiter (" + RandomGenerator.DEFAULT_DELIMITER + ")", false);
                        Main.writeMessage("String to randomize:", false);
                        Main.writeMessage(args[0], false);
                        returnString = randomGenerator.randomize(args[0], RandomGenerator.DEFAULT_DELIMITER);
                    } else {
                        String hasCustomDelimiter = null;
                        String hasReturnListSize = null;
                        if (args.length >= 3) {
                            if (args[1].equals("-delimiter")) {
                                hasCustomDelimiter = args[2];
                            } else if (args[1].equals("-returnSize")) {
                                hasReturnListSize = args[2];
                            } else {
                                throw new Exception("An error has occurred: arg " + args[1] + " is not a valid option");
                            }
                        }
                        if (args.length == 5) {
                            if (args[3].equals("-delimiter")) {
                                hasCustomDelimiter = args[4];
                            } else if (args[3].equals("-returnSize")) {
                                hasReturnListSize = args[4];
                            } else {
                                throw new Exception("An error has occurred: arg " + args[3] + " is not a valid option");
                            }
                        }
                        logger.debug("hasCustomDelimiter = " + hasCustomDelimiter);
                        logger.debug("hasReturnListSize = " + hasReturnListSize);
                        if (hasReturnListSize != null) {
                            returnListSize = new Integer(hasReturnListSize);
                        }
                        if (hasCustomDelimiter != null && hasReturnListSize != null) {
                            Main.writeMessage("Randomizing string with custom delimiter (" + hasCustomDelimiter + "), returning only " + returnListSize + " elements", false);
                            Main.writeMessage("String to randomize:", false);
                            Main.writeMessage(args[0], false);
                            returnString = randomGenerator.randomize(args[0], hasCustomDelimiter, returnListSize);
                        } else if (hasCustomDelimiter != null) {
                            Main.writeMessage("Randomizing string with custom delimiter (" + hasCustomDelimiter + ")", false);
                            Main.writeMessage("String to randomize:", false);
                            Main.writeMessage(args[0], false);
                            returnString = randomGenerator.randomize(args[0], hasCustomDelimiter);
                        } else if (hasReturnListSize != null) {
                            Main.writeMessage("Randomizing string with default delimiter (" + RandomGenerator.DEFAULT_DELIMITER + "), returning only " + hasReturnListSize + " elements", false);
                            Main.writeMessage("String to randomize:", false);
                            Main.writeMessage(args[0], false);
                            returnString = randomGenerator.randomize(args[0], RandomGenerator.DEFAULT_DELIMITER, returnListSize);
                        }
                    }
                    logger.debug("returnString = " + returnString);
                    Main.writeMessage("Randomized string:", false);
                    Main.writeMessage(returnString, false);
                    break block40;
                }
                if (args != null && args.length == 6) {
                    String randomDataMode = null;
                    String dataType = null;
                    NameFormat nameFormat = null;
                    Integer returnSize = null;
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].equals("-randomData")) {
                            randomDataMode = "randomData";
                            if (!args[++i].equals("fullNames")) continue;
                            dataType = "fullNames";
                            continue;
                        }
                        if (args[i].equals("-nameFormat")) {
                            if (!NameFormat.valueOf(args[++i]).equals((Object)NameFormat.FIRST_LAST) && !NameFormat.valueOf(args[i]).equals((Object)NameFormat.LAST_FIRST)) continue;
                            nameFormat = NameFormat.valueOf(args[i]);
                            continue;
                        }
                        if (!args[i].equals("-returnSize")) continue;
                        returnSize = Integer.valueOf(args[++i]);
                    }
                    if (randomDataMode == null || dataType == null || nameFormat == null || returnSize == null) {
                        Main.getHelpText(RandomGenerator.DEFAULT_DELIMITER);
                    }
                    Main.writeMessage("Returning a random list of full names containing " + args[5] + " value(s) in " + args[3] + " format.", true);
                    List<String> fullNames = randomGeneratorData.randomizeFullNames(nameFormat, returnSize);
                    returnString = String.join((CharSequence)"\n", fullNames);
                    logger.debug("returnString = " + returnString);
                    Main.writeMessage("Randomized names:", false);
                    Main.writeMessage(returnString, false);
                } else {
                    Main.getHelpText(RandomGenerator.DEFAULT_DELIMITER);
                }
            }
            catch (Exception e) {
                Main.writeMessage("An unexpected error occurred.", true);
                Main.writeMessage(e.getMessage(), true);
                Main.getHelpText(RandomGenerator.DEFAULT_DELIMITER);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        logger.error(ioe.getMessage());
                        Main.writeMessage("An error occurred while trying to read the properties.yml file.", true);
                        Main.writeMessage(ioe.getMessage(), true);
                    }
                }
            }
        }
    }

    private static void getHelpText(String defaultDelimiter) {
        Main.writeMessage("Usage: java -jar random-generator-version listString [options]", true);
        Main.writeMessage("  where:", false);
        Main.writeMessage("    listString = a concatenated list using either the default delimiter (" + defaultDelimiter + ")", false);
        Main.writeMessage("                 or the value of the delimiterString provided.", true);
        Main.writeMessage("  options:", false);
        Main.writeMessage("    -delimiter = the custom delimiter to use.", true);
        Main.writeMessage("    -returnSize = the number of elements to return.", true);
        Main.writeMessage("  examples:", false);
        Main.writeMessage("    java -jar random-generator-version One~~~Two~~~Three~~Four~~~Five~~~", false);
        Main.writeMessage("      Randomizes a list of five elements using the default delimiter (" + defaultDelimiter + ")", true);
        Main.writeMessage("    java -jar random-generator-version One^^Two^^Three^^Four^^Five^^ -delimiter ^^", false);
        Main.writeMessage("      Randomizes a list of five elements using a custom delimiter (^^)", true);
        Main.writeMessage("    java -jar random-generator-version One~~~Two~~~Three~~~Four~~~Five~~~ -returnSize 3", false);
        Main.writeMessage("      Randomizes a list of five elements using the default delimiter (" + defaultDelimiter + "), returning only three elements", true);
        Main.writeMessage("    java -jar random-generator-version One^^Two^^Three^^Four^^Five^^ -delimiter ^^ -returnSize 3", false);
        Main.writeMessage("      Randomizes a list of five elements using a custom delimiter (^^), returning only three elements", true);
        Main.writeMessage("    java -jar random-generator-version -randomData fullNames -nameFormat FIRST_LAST -returnSize 101", false);
        Main.writeMessage("      Returns a list of 101 random full names in first name last name format", true);
    }

    private static void writeMessage(String message, boolean newLine) {
        System.out.println(message);
        if (newLine) {
            System.out.println();
        }
    }
}

