package br.com.jhonsapp.notifier.implementation;

import java.io.Serializable;

/**
 * Interface that defines a notification.
 * 
 * @author Jhonathan Camacho
 */
public interface Notification extends Serializable {

	/**
	 * Gets the sender of the notification.
	 * 
	 * @return the sender.
	 */
	public String getSender();

	/**
	 * Gets the subject of the notification.
	 * 
	 * @return the subject.
	 */
	public String getSubject();

	/**
	 * Gets the notification message.
	 * 
	 * @return the message.
	 */
	public String getMessage();
}