/*
 * Decompiled with CFR 0.152.
 */
package br.com.jhonsapp.notifier.email;

import br.com.jhonsapp.notifier.abstraction.Notification;
import br.com.jhonsapp.notifier.abstraction.Notifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Component;

@Component
public class NotifierByEmail
implements Notifier {
    private static final long serialVersionUID = -9145832296675317025L;
    @Autowired
    public JavaMailSender emailSender;

    @Override
    public boolean notify(Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("The notification can not be null.");
        }
        try {
            SimpleMailMessage simpleMessage = new SimpleMailMessage();
            simpleMessage.setTo(notification.getAddressee());
            simpleMessage.setSubject(notification.getSubject());
            simpleMessage.setText(notification.getMessage());
            this.emailSender.send(simpleMessage);
            return true;
        }
        catch (MailException e) {
            return false;
        }
    }
}

