package br.com.jhonsapp.notifier;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.inject.Qualifier;

/**
 * NotifierType Qualifier.
 * 
 * @author Jhonathan Camacho
 */
@Qualifier
@Retention(RUNTIME)
@Target({ FIELD, TYPE, METHOD })
public @interface NotifierType {

	ServiceType value();

	public enum ServiceType {
		EMAIL, SMS;
	}
}
