/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.muyie.framework.service.filter.Filter;
import org.muyie.framework.service.filter.RangeFilter;
import org.muyie.framework.service.filter.StringFilter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class QueryService<E> {
    protected <X> Specification<E> buildSpecification(Filter<X> filter, SingularAttribute<? super E, X> field) {
        return this.buildSpecification(filter, (Root<E> root) -> root.get(field));
    }

    protected <X> Specification<E> buildSpecification(Filter<X> filter, Function<Root<E>, Expression<X>> metaclassFunction) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(metaclassFunction, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(metaclassFunction, filter.getIn());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(metaclassFunction, filter.getSpecified());
        }
        return null;
    }

    protected Specification<E> buildStringSpecification(StringFilter filter, SingularAttribute<? super E, String> field) {
        return this.buildSpecification(filter, (Root<E> root) -> root.get(field));
    }

    protected Specification<E> buildSpecification(StringFilter filter, Function<Root<E>, Expression<String>> metaclassFunction) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(metaclassFunction, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(metaclassFunction, filter.getIn());
        }
        if (filter.getContains() != null) {
            return this.likeUpperSpecification(metaclassFunction, filter.getContains());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(metaclassFunction, filter.getSpecified());
        }
        return null;
    }

    protected <X extends Comparable<? super X>> Specification<E> buildRangeSpecification(RangeFilter<X> filter, SingularAttribute<? super E, X> field) {
        return this.buildSpecification(filter, (Root<E> root) -> root.get(field));
    }

    protected <X extends Comparable<? super X>> Specification<E> buildSpecification(RangeFilter<X> filter, Function<Root<E>, Expression<X>> metaclassFunction) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(metaclassFunction, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(metaclassFunction, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(metaclassFunction, filter.getSpecified()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan(metaclassFunction, filter.getGreaterThan()));
        }
        if (filter.getGreaterThanOrEqual() != null) {
            result = result.and(this.greaterThanOrEqualTo(metaclassFunction, filter.getGreaterThanOrEqual()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan(metaclassFunction, filter.getLessThan()));
        }
        if (filter.getLessThanOrEqual() != null) {
            result = result.and(this.lessThanOrEqualTo(metaclassFunction, filter.getLessThanOrEqual()));
        }
        return result;
    }

    protected <OTHER, X> Specification<E> buildReferringEntitySpecification(Filter<X> filter, SingularAttribute<? super E, OTHER> reference, SingularAttribute<? super OTHER, X> valueField) {
        return this.buildSpecification(filter, (Root<E> root) -> root.get(reference).get(valueField));
    }

    protected <OTHER, X> Specification<E> buildReferringEntitySpecification(Filter<X> filter, SetAttribute<E, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        return this.buildReferringEntitySpecification(filter, (Root<E> root) -> root.join(reference), (SetJoin<MISC, OTHER> entity) -> entity.get(valueField));
    }

    protected <OTHER, MISC, X> Specification<E> buildReferringEntitySpecification(Filter<X> filter, Function<Root<E>, SetJoin<MISC, OTHER>> functionToEntity, Function<SetJoin<MISC, OTHER>, Expression<X>> entityToColumn) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(functionToEntity.andThen(entityToColumn), filter.getEquals());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(root -> (SetJoin)functionToEntity.apply((Root)root), filter.getSpecified());
        }
        return null;
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<E> buildReferringEntitySpecification(RangeFilter<X> filter, SetAttribute<E, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        return this.buildReferringEntitySpecification(filter, (Root<E> root) -> root.join(reference), (SetJoin<MISC, OTHER> entity) -> entity.get(valueField));
    }

    protected <OTHER, MISC, X extends Comparable<? super X>> Specification<E> buildReferringEntitySpecification(RangeFilter<X> filter, Function<Root<E>, SetJoin<MISC, OTHER>> functionToEntity, Function<SetJoin<MISC, OTHER>, Expression<X>> entityToColumn) {
        Function<Root<E>, Expression<X>> fused = functionToEntity.andThen(entityToColumn);
        if (filter.getEquals() != null) {
            return this.equalsSpecification(fused, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(fused, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(root -> (SetJoin)functionToEntity.apply((Root)root), filter.getSpecified()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan(fused, filter.getGreaterThan()));
        }
        if (filter.getGreaterThanOrEqual() != null) {
            result = result.and(this.greaterThanOrEqualTo(fused, filter.getGreaterThanOrEqual()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan(fused, filter.getLessThan()));
        }
        if (filter.getLessThanOrEqual() != null) {
            result = result.and(this.lessThanOrEqualTo(fused, filter.getLessThanOrEqual()));
        }
        return result;
    }

    protected <X> Specification<E> equalsSpecification(Function<Root<E>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)metaclassFunction.apply(root), value);
    }

    protected Specification<E> likeUpperSpecification(Function<Root<E>, Expression<String>> metaclassFunction, String value) {
        return (Specification & Serializable)(root, query, builder) -> builder.like(builder.upper((Expression)metaclassFunction.apply(root)), this.wrapLikeQuery(value));
    }

    protected <X> Specification<E> byFieldSpecified(Function<Root<E>, Expression<X>> metaclassFunction, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, builder) -> builder.isNotNull((Expression)metaclassFunction.apply(root)) : (Specification & Serializable)(root, query, builder) -> builder.isNull((Expression)metaclassFunction.apply(root));
    }

    protected <X> Specification<E> byFieldEmptiness(Function<Root<E>, Expression<Set<X>>> metaclassFunction, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, builder) -> builder.isNotEmpty((Expression)metaclassFunction.apply(root)) : (Specification & Serializable)(root, query, builder) -> builder.isEmpty((Expression)metaclassFunction.apply(root));
    }

    protected <X> Specification<E> valueIn(Function<Root<E>, Expression<X>> metaclassFunction, Collection<X> values) {
        return (Specification & Serializable)(root, query, builder) -> {
            CriteriaBuilder.In in = builder.in((Expression)metaclassFunction.apply(root));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    protected <X extends Comparable<? super X>> Specification<E> greaterThanOrEqualTo(Function<Root<E>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThanOrEqualTo((Expression)metaclassFunction.apply(root), value);
    }

    protected <X extends Comparable<? super X>> Specification<E> greaterThan(Function<Root<E>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThan((Expression)metaclassFunction.apply(root), value);
    }

    protected <X extends Comparable<? super X>> Specification<E> lessThanOrEqualTo(Function<Root<E>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThanOrEqualTo((Expression)metaclassFunction.apply(root), value);
    }

    protected <X extends Comparable<? super X>> Specification<E> lessThan(Function<Root<E>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThan((Expression)metaclassFunction.apply(root), value);
    }

    protected String wrapLikeQuery(String txt) {
        return "%" + txt.toUpperCase() + '%';
    }
}

