/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.security.ssl;

import io.undertow.UndertowOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={UndertowServletWebServerFactory.class, UndertowOptions.class})
@ConditionalOnProperty(value={"server.ssl.ciphers", "server.ssl.key-store"})
public class UndertowSSLConfiguration {
    private final UndertowServletWebServerFactory factory;
    private final Logger log = LoggerFactory.getLogger(UndertowSSLConfiguration.class);

    public UndertowSSLConfiguration(UndertowServletWebServerFactory undertowServletWebServerFactory) {
        this.factory = undertowServletWebServerFactory;
        this.configuringUserCipherSuiteOrder();
    }

    private void configuringUserCipherSuiteOrder() {
        this.log.info("Configuring Undertow");
        this.log.info("Setting user cipher suite order to true");
        this.factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setSocketOption(UndertowOptions.SSL_USER_CIPHER_SUITES_ORDER, (Object)Boolean.TRUE)});
    }
}

