/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.security.jwt;

import javax.servlet.Filter;
import org.muyie.framework.config.MuyieProperties;
import org.muyie.framework.security.jwt.JwtConfigurer;
import org.muyie.framework.security.jwt.JwtTokenProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
@AutoConfigureAfter(value={MuyieProperties.class})
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class, JwtTokenProvider.class})
public class JwtSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final JwtTokenProvider tokenProvider;
    private final SecurityProblemSupport problemSupport;
    private final CorsFilter corsFilter;

    public JwtSecurityConfiguration(JwtTokenProvider tokenProvider, SecurityProblemSupport problemSupport, CorsFilter corsFilter) {
        this.tokenProvider = tokenProvider;
        this.problemSupport = problemSupport;
        this.corsFilter = corsFilter;
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/**/*.{js,html}"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/swagger-ui/index.html"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).addFilterBefore((Filter)this.corsFilter, UsernamePasswordAuthenticationFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().frameOptions().disable().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ROLE_ADMIN").and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private JwtConfigurer securityConfigurerAdapter() {
        return new JwtConfigurer(this.tokenProvider);
    }
}

