/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.data.jpa.specification;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.muyie.framework.data.jpa.specification.AbstractSpecification;

public class NotLikeSpecification<T>
extends AbstractSpecification<T> {
    private static final long serialVersionUID = 1L;
    private final String property;
    private final List<String> patterns;

    public NotLikeSpecification(String property, List<String> patterns) {
        this(property, patterns, JoinType.INNER);
    }

    public NotLikeSpecification(String property, List<String> patterns, JoinType joinType) {
        super(joinType);
        this.property = property;
        this.patterns = patterns;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        From<?, ?> from = this.getRoot(this.property, root);
        String field = this.getProperty(this.property);
        Predicate[] predicates = new Predicate[this.patterns.size()];
        for (int i = 0; i < this.patterns.size(); ++i) {
            predicates[i] = criteriaBuilder.notLike((Expression)from.get(field), this.patterns.get(i));
        }
        return criteriaBuilder.or(predicates);
    }
}

