/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.data.jpa.specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.muyie.framework.data.jpa.specification.AbstractSpecification;

public class BetweenSpecification<T>
extends AbstractSpecification<T> {
    private static final long serialVersionUID = 1L;
    private final String property;
    private final Comparable<Object> lower;
    private final Comparable<Object> upper;

    public BetweenSpecification(String property, Object lower, Object upper) {
        this(property, lower, upper, JoinType.INNER);
    }

    public BetweenSpecification(String property, Object lower, Object upper, JoinType joinType) {
        super(joinType);
        this.property = property;
        this.lower = (Comparable)lower;
        this.upper = (Comparable)upper;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        From<?, ?> from = this.getRoot(this.property, root);
        String field = this.getProperty(this.property);
        return criteriaBuilder.between((Expression)from.get(field), this.lower, this.upper);
    }
}

