/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.config.aspectj;

import cn.hutool.core.util.StrUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.muyie.framework.aop.AroundAdvice;
import org.muyie.framework.config.aspectj.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class StopWatchAspect
implements AroundAdvice {
    private static final Logger log = LoggerFactory.getLogger(StopWatchAspect.class);

    @Override
    @Pointcut(value="@annotation(org.muyie.framework.config.aspectj.StopWatch)")
    public void setPointcut() {
    }

    @Pointcut(value="within(@org.springframework.stereotype.Repository *) || within(@org.springframework.stereotype.Service *) || within(@org.springframework.web.bind.annotation.RestController *)")
    public void springBeanPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Around(value="setPointcut() && springBeanPointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        String value = this.getMethod(joinPoint).getAnnotation(StopWatch.class).value();
        if (StringUtils.isEmpty((Object)value)) {
            value = StrUtil.format((CharSequence)"{}.{}()", (Object[])new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName()});
        }
        org.springframework.util.StopWatch stopWatch = new org.springframework.util.StopWatch(value);
        stopWatch.start();
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            stopWatch.stop();
            log.info(stopWatch.shortSummary());
        }
    }
}

