/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Xml {
    private final String name;
    private String value;
    private final List<Xml> children = new ArrayList<Xml>();
    private Xml parent;
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    public Xml() {
        this.name = null;
    }

    public Xml append(Xml tag) {
        this.children.add(tag);
        return this;
    }

    public Xml append(Stream<Xml> tags) {
        this.children.addAll(tags.collect(Collectors.toList()));
        return this;
    }

    public Xml p(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public Xml done() {
        return this.parent;
    }

    public Xml v(String value) {
        this.value = value;
        return this;
    }

    public Xml(Xml parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public Xml tag(String name) {
        Xml t = new Xml(this, name);
        this.append(t);
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("<").append(this.name);
            this.params.entrySet().stream().forEach(e -> sb.append(" ").append((String)e.getKey()).append("=\"").append((String)e.getValue()).append("\""));
            sb.append(">");
        }
        if (this.value != null) {
            sb.append(this.value);
        }
        this.children.forEach(ch -> sb.append(ch.toString()));
        if (this.name != null) {
            sb.append("</").append(this.name).append(">");
        }
        return sb.toString();
    }
}

