/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.io;

import com.zakgof.tools.io.ISimpleSerializer;
import com.zakgof.tools.io.SimpleInputStream;
import com.zakgof.tools.io.SimpleOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleCollectionSerializer<T, S extends ISimpleSerializer<T>>
implements ISimpleSerializer<Collection<T>> {
    private final S elementSerializer;

    public SimpleCollectionSerializer(S elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    @Override
    public void write(SimpleOutputStream out, Collection<T> val) throws IOException {
        out.write(val.size());
        for (T t : val) {
            this.elementSerializer.write(out, t);
        }
    }

    @Override
    public List<T> read(SimpleInputStream in) throws IOException {
        int length = in.readInt();
        ArrayList arr = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            arr.add(this.elementSerializer.read(in));
        }
        return arr;
    }
}

