/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.io;

import com.zakgof.tools.io.ISimpleSerializer;
import com.zakgof.tools.io.SimpleInputStream;
import com.zakgof.tools.io.SimpleOutputStream;
import java.io.IOException;

public class SimpleClassSerializer
implements ISimpleSerializer<Class<?>> {
    public static SimpleClassSerializer INSTANCE = new SimpleClassSerializer();

    @Override
    public void write(SimpleOutputStream out, Class<?> val) throws IOException {
        out.write(val.getName());
    }

    @Override
    public Class<?> read(SimpleInputStream in) throws IOException {
        String className = in.readString();
        try {
            switch (className) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Can't load class " + className);
        }
    }
}

