/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.generic;

import java.util.function.Function;

public class Pair<K, V> {
    private final K key;
    private final V value;

    public Pair(K k, V v) {
        this.key = k;
        this.value = v;
    }

    public Pair(Pair<? extends K, ? extends V> entry) {
        this(entry.first(), entry.second());
    }

    public K first() {
        return this.key;
    }

    public V second() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair oP = (Pair)o;
        return (this.key == null ? oP.key == null : this.key.equals(oP.key)) && (this.value == null ? oP.value == null : this.value.equals(oP.value));
    }

    public int hashCode() {
        int result = this.key == null ? 0 : this.key.hashCode();
        int h = this.value == null ? 0 : this.value.hashCode();
        result = 37 * result + h ^ h >>> 16;
        return result;
    }

    public String toString() {
        return "[" + this.first() + ", " + this.second() + "]";
    }

    public static <K, V> Pair<K, V> create(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    public <K2> Pair<K2, V> fixFirst(Function<K, K2> firstFixer) {
        return Pair.create(firstFixer.apply(this.key), this.value);
    }

    public <V2> Pair<K, V2> fixSecond(Function<V, V2> secondFixer) {
        return Pair.create(this.key, secondFixer.apply(this.value));
    }
}

