/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Supplier;

public class Merger<C extends Comparable<C>> {
    private Comparator<C> comparator;
    private final PriorityQueue<Wrapper<?>> queue = new PriorityQueue();
    private final List<Source<?>> sources = new ArrayList();

    public Merger(Comparator<C> comparator) {
        this.comparator = comparator;
    }

    public <T> Wrapper<T> wrapFromStream(Source<T> src) {
        Object obj = ((Source)src).stream.get();
        if (obj != null) {
            return new Wrapper(obj, src);
        }
        return null;
    }

    public <T> void addSource(Function<T, C> metric, Supplier<T> stream) {
        this.sources.add(new Source<T>(stream, metric));
    }

    public void run() {
        for (Source<?> src : this.sources) {
            this.feedQueue(src);
        }
    }

    private <T> void feedQueue(Source<T> src) {
        Wrapper<T> w = this.wrapFromStream(src);
        if (w != null) {
            this.queue.add(w);
        }
    }

    public Map.Entry<C, Object> next() {
        final Wrapper<?> w = this.queue.poll();
        if (w == null) {
            return null;
        }
        this.feedQueue(w.source);
        return new Map.Entry<C, Object>(){

            @Override
            public C getKey() {
                return w.metric();
            }

            @Override
            public Object getValue() {
                return w.object;
            }

            @Override
            public Object setValue(Object value) {
                return null;
            }
        };
    }

    private class Wrapper<T>
    implements Comparable<Wrapper<T>> {
        T object;
        Source<T> source;

        public Wrapper(T obj, Source<T> src) {
            this.object = obj;
            this.source = src;
        }

        @Override
        public int compareTo(Wrapper<T> that) {
            return Merger.this.comparator.compare(this.metric(), that.metric());
        }

        public C metric() {
            return (Comparable)((Source)this.source).metric.apply(this.object);
        }
    }

    private class Source<T> {
        private final Function<T, C> metric;
        private final Supplier<T> stream;

        public Source(Supplier<T> stream, Function<T, C> metric) {
            this.stream = stream;
            this.metric = metric;
        }
    }
}

