/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Map2BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(Map2BeanUtil.class);

    public static Object convert(Map map, Object object) {
        if (map == null || object == null) {
            return null;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = Map2BeanUtil.toLowerCaseFirstOne(property.getName());
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(object, value);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static <T> void setProperty(T clazz, String field, Object value, int level) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String s;
                String key = Map2BeanUtil.toLowerCaseFirstOne(property.getName());
                if (!field.equals(key)) continue;
                Method setter = property.getWriteMethod();
                Class<?>[] parameterTypes = setter.getParameterTypes();
                if (parameterTypes[0].getName().equals("java.lang.String")) {
                    setter.invoke(clazz, String.valueOf(value));
                    continue;
                }
                if (parameterTypes[0].getName().equals("java.lang.Long")) {
                    s = String.valueOf(value);
                    if (s.contains(".")) {
                        setter.invoke(clazz, Long.valueOf(s.substring(0, s.indexOf("."))));
                        continue;
                    }
                    setter.invoke(clazz, Long.valueOf(s));
                    continue;
                }
                if (parameterTypes[0].getName().equals("java.lang.Integer")) {
                    s = String.valueOf(value);
                    if (s.contains(".")) {
                        setter.invoke(clazz, Integer.valueOf(s.substring(0, s.indexOf("."))));
                        continue;
                    }
                    setter.invoke(clazz, Integer.valueOf(s));
                    continue;
                }
                if (parameterTypes[0].getName().equals("java.lang.Float")) {
                    setter.invoke(clazz, Float.valueOf(String.valueOf(value)));
                    continue;
                }
                if (parameterTypes[0].getName().equals("int")) {
                    setter.invoke(clazz, (int)Integer.valueOf(String.valueOf(value)));
                    continue;
                }
                setter.invoke(clazz, parameterTypes[0].cast(value));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private Map2BeanUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

