/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullMask;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import com.suke.zhjg.common.autofull.util.CryptUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullMask.class)
public class AutoFullMaskService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullMaskService.class);

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullMask) {
                field.setAccessible(true);
                AutoFullMask autoFullMask = field.getAnnotation(AutoFullMask.class);
                String data = (String)field.get(obj);
                if (StrUtil.isNotEmpty((CharSequence)data) && StrUtil.isNotBlank((CharSequence)data)) {
                    String cutValue = "";
                    switch (autoFullMask.type()) {
                        case CHINESE_NAME: {
                            cutValue = DesensitizedUtil.chineseName((String)data);
                            break;
                        }
                        case ID_CARD: {
                            cutValue = DesensitizedUtil.idCardNum((String)data, (int)1, (int)2);
                            break;
                        }
                        case FIXED_PHONE: {
                            cutValue = DesensitizedUtil.fixedPhone((String)data);
                            break;
                        }
                        case MOBILE_PHONE: {
                            cutValue = DesensitizedUtil.mobilePhone((String)data);
                            break;
                        }
                        case ADDRESS: {
                            cutValue = DesensitizedUtil.address((String)data, (int)8);
                            break;
                        }
                        case EMAIL: {
                            cutValue = DesensitizedUtil.email((String)data);
                            break;
                        }
                        case PASSWORD: {
                            cutValue = DesensitizedUtil.password((String)data);
                            break;
                        }
                        case CAR_LICENSE: {
                            cutValue = DesensitizedUtil.carLicense((String)data);
                            break;
                        }
                        case BANK_CARD: {
                            cutValue = DesensitizedUtil.bankCard((String)data);
                        }
                    }
                    String encrypt = CryptUtil.encrypt(data);
                    if (this.configProperties.isShowLog()) {
                        log.info("ID:{}, LEVEL:{}, \u8131\u654f\u6570\u636e\u52a0\u5bc6\uff1a{} \u5bc6\u94a5\uff1a{}", new Object[]{sequence, level, cutValue, encrypt});
                    }
                    field.set(obj, cutValue + this.configProperties.getEncryptFlag() + encrypt);
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145\u6570\u636e\u8131\u654f\u5931\u8d25,{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

