/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullField;
import com.suke.zhjg.common.autofull.cache.AutoFullRedisCache;
import com.suke.zhjg.common.autofull.constant.ConstantSQL;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import com.suke.zhjg.common.autofull.sequence.AutoSequence;
import com.suke.zhjg.common.autofull.sql.AutoFullSqlJdbcTemplate;
import com.suke.zhjg.common.autofull.util.ClassTypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullField.class)
public class AutoFullFieldService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullFieldService.class);

    @Override
    public String sql(String table, String queryField, String alias, String conditionField) {
        alias = this.getConditionField(alias);
        String field = StrUtil.isBlank((CharSequence)(queryField = this.getConditionField(queryField))) ? alias : queryField + " " + (Object)((Object)ConstantSQL.SQL.AS) + " " + alias;
        conditionField = this.getConditionField(conditionField);
        String sql = (Object)((Object)ConstantSQL.SQL.SELECT) + " " + field + " " + (Object)((Object)ConstantSQL.SQL.FROM) + " " + table + " " + (Object)((Object)ConstantSQL.SQL.WHERE) + " " + conditionField + "  =  ?";
        return sql;
    }

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullField) {
                Object object = AutoSequence.init().get(sequence);
                AutoFullField fieldAnnotation = field.getAnnotation(AutoFullField.class);
                field.setAccessible(true);
                String alias = field.getName();
                String table = fieldAnnotation.table();
                String tableField = fieldAnnotation.conditionField();
                String queryField = fieldAnnotation.queryField();
                boolean useCache = fieldAnnotation.useCache();
                Object param = this.findFieldValue(fields, tableField, obj);
                if (ObjectUtil.isNotNull((Object)param)) {
                    String parseSql = this.sql(table, queryField, alias, tableField);
                    if (this.configProperties.isShowLog()) {
                        log.info("ID:{}, LEVEL:{}, SQL:{}", new Object[]{sequence, level, parseSql});
                        log.info("ID:{}, LEVEL:{}, param\uff1a{}", new Object[]{sequence, level, param});
                    }
                    String result = null;
                    if (useCache) {
                        String stringData = AutoFullRedisCache.getStringData(sequence, parseSql, param);
                        if (StrUtil.isNotEmpty((CharSequence)stringData)) {
                            result = stringData;
                        } else {
                            result = AutoFullSqlJdbcTemplate.queryObj(parseSql, String.class, param);
                            AutoFullRedisCache.setData(sequence, parseSql, param, result);
                        }
                    } else {
                        result = AutoFullSqlJdbcTemplate.queryObj(parseSql, String.class, param);
                    }
                    if (StrUtil.isNotEmpty((CharSequence)result)) {
                        ClassTypeUtil.setValue(obj, field, result);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145\u5b57\u6bb5\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

