/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableCaching
@Configuration
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
public class RedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);

    @Bean(value={"redisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        stringRedisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        stringRedisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
        stringRedisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        stringRedisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
        stringRedisTemplate.setConnectionFactory(redisConnectionFactory);
        return stringRedisTemplate;
    }
}

