/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.druid;

import com.github.youyinnn.youdbutils.YouDbManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ThreadLocalPropContainer {
    private static ThreadLocal<Connection> threadConnection = new ThreadLocal();
    private static ThreadLocal<Boolean> threadNeedToRollback = new ThreadLocal();
    private static ThreadLocal<Boolean> threadAllowNoneffectiveUpdate = new ThreadLocal();
    private static ThreadLocal<String> transactionRootServiceMethodName = new ThreadLocal();

    private static void bindConn(Connection connection) {
        threadConnection.set(connection);
    }

    public static boolean setRollbackFlagTrue() {
        threadNeedToRollback.set(true);
        return true;
    }

    public static boolean setRollbackFlagFalse() {
        threadNeedToRollback.set(false);
        return false;
    }

    public static boolean setNoneffectiveUpdateFlag(boolean flag) {
        threadAllowNoneffectiveUpdate.set(flag);
        return flag;
    }

    public static void bindTransactionRootServiceMethodName(String serviceMethodName) {
        transactionRootServiceMethodName.set(serviceMethodName);
    }

    public static Connection getThreadConnection(String dataSourceName) {
        Connection connection = threadConnection.get();
        if (connection == null) {
            try {
                connection = YouDbManager.youDruid(dataSourceName).getCurrentDataSourceConn();
                ThreadLocalPropContainer.bindConn(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return connection;
    }

    public static Boolean getRollbackFlag() {
        Boolean needToRollBack = threadNeedToRollback.get();
        return needToRollBack == null ? ThreadLocalPropContainer.setRollbackFlagFalse() : needToRollBack;
    }

    public static Boolean getNoneffectiveUpdateFlag() {
        Boolean allowNoneffectiveUpdate = threadAllowNoneffectiveUpdate.get();
        return allowNoneffectiveUpdate == null ? ThreadLocalPropContainer.setNoneffectiveUpdateFlag(true) : allowNoneffectiveUpdate;
    }

    public static String getTransactionRootServiceMethodName() {
        return transactionRootServiceMethodName.get();
    }

    public static void removeRollbackFlag() {
        threadNeedToRollback.remove();
    }

    public static void removeThreadConnection() {
        threadConnection.remove();
    }

    public static void removeNoneffectiveUpdateFlag() {
        threadAllowNoneffectiveUpdate.remove();
    }

    public static void removeTransactionRootServiceMethodName() {
        transactionRootServiceMethodName.remove();
    }

    public static void release(ResultSet resultSet, Statement statement, Connection connection) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void removeAllThreadProp() {
        ThreadLocalPropContainer.removeNoneffectiveUpdateFlag();
        ThreadLocalPropContainer.removeRollbackFlag();
        ThreadLocalPropContainer.removeThreadConnection();
        ThreadLocalPropContainer.removeTransactionRootServiceMethodName();
    }
}

