/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.dao.model;

import com.github.youyinnn.youdbutils.YouDbManager;
import com.github.youyinnn.youdbutils.dao.model.FieldMapping;
import com.github.youyinnn.youwebutils.third.DbUtils;
import com.github.youyinnn.youwebutils.third.Log4j2Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ModelTableMessage {
    private static final Logger logger = Log4j2Helper.getLogger((String)"$db_manager");
    private static HashMap<String, String> modelTableNameMapping = new HashMap(5);
    private static HashMap<String, ArrayList<String>> allModelField = new HashMap(5);
    private static HashMap<String, ArrayList<String>> allTableField = new HashMap(5);
    private static HashMap<String, FieldMapping> allModelTableFieldMapping = new HashMap(5);

    public static void registerModelFieldMessage(String modelClassName, ArrayList<String> fieldList) {
        allModelField.put(modelClassName, fieldList);
    }

    public static void registerTableFieldMessage(String tableName, ArrayList<String> fieldList) {
        allTableField.put(tableName, fieldList);
    }

    public static void registerModelTableNameMappingMessage(String modelName, String tableName) {
        modelTableNameMapping.put(modelName, tableName);
    }

    public static FieldMapping getFieldMapping(String modelName) {
        return allModelTableFieldMapping.get(modelName);
    }

    public static void setFieldMapping(String dataSourceName) {
        Set<String> modelNames = allModelField.keySet();
        for (String modelName : modelNames) {
            ArrayList<String> mFields = allModelField.get(modelName);
            ArrayList<String> tColumns = allTableField.get(modelName);
            for (String mField : mFields) {
                boolean mapping = tColumns.contains(mField) || tColumns.contains(DbUtils.turnToAlibabaDataBaseNamingRules((String)mField));
                if (mapping) continue;
                if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                    logger.error("\u6570\u636e\u6e90: \"{}\" \u7684Model\u7c7b\u548c\u6570\u636e\u8868\u7684\u626b\u63cf\u7ed3\u679c\u6709\u8bef, \u8868:{}\u4e2d\u4e0d\u5b58\u5728{}\u6216\u8005{}\u5217, \u7a0b\u5e8f\u7ec8\u6b62!", (Object)dataSourceName, (Object)modelName, (Object)mField, (Object)DbUtils.turnToAlibabaDataBaseNamingRules((String)mField));
                }
                System.exit(0);
            }
            allModelTableFieldMapping.put(modelName, new FieldMapping(modelName, allModelField.get(modelName), allTableField.get(modelName)));
        }
        if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
            logger.info("\u6570\u636e\u6e90: \"{}\" Model\u548c\u8868\u7684\u6620\u5c04\u5bf9\u5e94\u5b8c\u6210!", (Object)dataSourceName);
        }
    }

    public static HashMap<String, ArrayList<String>> getAllModelField() {
        return allModelField;
    }

    public static HashMap<String, ArrayList<String>> getAllTableField() {
        return allTableField;
    }

    public static ArrayList<String> getModelFieldList(String modelClassName) {
        return allModelField.get(modelClassName);
    }

    public static Set<String> getAllModelNameSet() {
        return allModelField.keySet();
    }

    public static HashMap<String, FieldMapping> getAllModelTableFieldMapping() {
        return allModelTableFieldMapping;
    }

    public static String getTableName(String modelName) {
        return modelTableNameMapping.get(modelName);
    }
}

