/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.dao.model;

import com.github.youyinnn.youdbutils.dao.model.FieldMapping;
import com.github.youyinnn.youdbutils.dao.model.ModelTableMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MappingHandler {
    public static ArrayList<String> mappingHandle(String modelName, ArrayList<String> modelField) throws NoSuchFieldException {
        if (modelField == null) {
            return null;
        }
        FieldMapping fieldMapping = ModelTableMessage.getFieldMapping(modelName);
        if (fieldMapping != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String mField : modelField) {
                if (fieldMapping.needToReplace(mField)) {
                    result.add(fieldMapping.getTableField(mField));
                    continue;
                }
                result.add(mField);
            }
            return result;
        }
        return modelField;
    }

    public static ArrayList<String> mappingHandle(String modelName, Set<String> modelField) throws NoSuchFieldException {
        return MappingHandler.mappingHandle(modelName, new ArrayList<String>(modelField));
    }

    public static HashMap<String, Object> mappingHandle(String modelName, HashMap<String, Object> modelField) throws NoSuchFieldException {
        if (modelField == null) {
            return null;
        }
        HashMap<String, Object> tableField = new HashMap<String, Object>(10);
        FieldMapping fieldMapping = ModelTableMessage.getFieldMapping(modelName);
        Set<String> mFieldSet = modelField.keySet();
        for (String mField : mFieldSet) {
            Object value = modelField.get(mField);
            if (fieldMapping.needToReplace(mField)) {
                tableField.put(fieldMapping.getTableField(mField), value);
                continue;
            }
            tableField.put(mField, value);
        }
        return tableField;
    }

    public static String mappingHandle(String modelName, String modelField) throws NoSuchFieldException {
        FieldMapping fieldMapping = ModelTableMessage.getFieldMapping(modelName);
        if (fieldMapping.needToReplace(modelField)) {
            return fieldMapping.getTableField(modelField);
        }
        return modelField;
    }
}

