/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.ThreadsScheduler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedScheduler
extends ThreadsScheduler {
    protected static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    protected static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    protected static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    protected static final int KEEP_ALIVE = 1;
    protected static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SharedThread #" + this.mCount.getAndIncrement());
        }
    };
    protected static BlockingQueue<Runnable> QUEUE;
    protected static ThreadPoolExecutor EXECUTOR;
    protected static SharedScheduler DEF_SCHEDULE;

    public static SharedScheduler getDefault() {
        return SharedScheduler.getDefault(SharedScheduler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedScheduler getDefault(Class<? extends SharedScheduler> type) {
        Class<SharedScheduler> clazz = SharedScheduler.class;
        synchronized (SharedScheduler.class) {
            if (DEF_SCHEDULE == null) {
                QUEUE = new LinkedBlockingQueue<Runnable>();
                EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, QUEUE, THREAD_FACTORY);
                if (SharedScheduler.class.equals(type)) {
                    DEF_SCHEDULE = new SharedScheduler();
                } else {
                    try {
                        DEF_SCHEDULE = type.newInstance();
                    }
                    catch (Exception cause) {
                        throw new RuntimeException("When create shared schedule instance", cause);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DEF_SCHEDULE;
        }
    }

    public SharedScheduler() {
        super(EXECUTOR, EXECUTOR);
    }

    public static void shutdown() {
        EXECUTOR.shutdown();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (EXECUTOR != null && !EXECUTOR.isShutdown()) {
                    EXECUTOR.shutdown();
                }
            }
        }));
    }
}

