/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events.emitter;

import com.github.yoojia.events.emitter.CallerScheduler;
import com.github.yoojia.events.emitter.EventFilter;
import com.github.yoojia.events.emitter.Handler;
import com.github.yoojia.events.emitter.OnEventHandler;
import com.github.yoojia.events.emitter.Scheduler;
import com.github.yoojia.events.emitter.Submit;
import com.github.yoojia.events.emitter.Target;
import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Functions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventEmitter {
    private final Submit mSubmit;
    final Scheduler scheduler;
    final CopyOnWriteArrayList<Target> targets = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<OnEventHandler> handlers = new CopyOnWriteArrayList();

    public EventEmitter() {
        this(new CallerScheduler());
    }

    public EventEmitter(Scheduler schedule) {
        this.scheduler = schedule;
        this.mSubmit = new Submit(this);
    }

    public void emit(Object event) {
        this.mSubmit.submit(event);
    }

    public void addHandler(Handler handler, EventFilter filter) {
        this.addHandler(handler, Arrays.asList(filter));
    }

    public void addHandler(Handler handler, List<EventFilter> filters) {
        this.addTarget(new Target(handler, filters));
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public void removeTarget(Target target) {
        this.removeHandler(target.handler);
    }

    public void removeHandler(final Handler handler) {
        this.targets.removeAll(Functions.filter(this.targets, new Filter<Target>(){

            @Override
            public boolean accept(Target item) {
                return item.handler.equals(handler);
            }
        }));
    }

    public void addOnEventHandler(OnEventHandler handler) {
        this.handlers.add(handler);
    }

    public void removeOnEventHandler(OnEventHandler handler) {
        this.handlers.remove(handler);
    }
}

