/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.MethodArgs;
import com.github.yoojia.events.MethodFilter;
import com.github.yoojia.events.MethodHandler;
import com.github.yoojia.events.Methods;
import com.github.yoojia.events.TargetList;
import com.github.yoojia.events.emitter.EventFilter;
import com.github.yoojia.events.emitter.Target;
import com.github.yoojia.events.supports.Filter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ObjectCached {
    private final Map<Object, TargetList> mCache = new ConcurrentHashMap<Object, TargetList>();

    ObjectCached() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetList findTargets(Object object, Filter<Method> methodFilter) {
        List<Method> methods = Methods.getAnnotated(object.getClass(), methodFilter);
        if (methods.isEmpty()) {
            return TargetList.empty();
        }
        Map<Object, TargetList> map = this.mCache;
        synchronized (map) {
            TargetList present = this.mCache.get(object);
            if (present != null) {
                return present;
            }
            int size = methods.size();
            ArrayList<Target> array = new ArrayList<Target>(size);
            for (int i = 0; i < size; ++i) {
                Method method = methods.get(i);
                array.add(ObjectCached.create(object, method, Methods.parse(method)));
            }
            TargetList acceptors = new TargetList(array);
            this.mCache.put(object, acceptors);
            return acceptors;
        }
    }

    public TargetList getPresent(Object object) {
        TargetList present = this.mCache.get(object);
        if (present == null) {
            return TargetList.empty();
        }
        return present;
    }

    public void remove(Object object) {
        this.mCache.remove(object);
    }

    private static Target create(Object object, Method method, MethodArgs args) {
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>(1);
        filters.add(new MethodFilter(args));
        return new Target(MethodHandler.create(args.scheduleOn, object, method, args), filters);
    }
}

