/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.EventPayload;
import com.github.yoojia.events.ObjectCached;
import com.github.yoojia.events.SharedScheduler;
import com.github.yoojia.events.TargetList;
import com.github.yoojia.events.emitter.DeadEvent;
import com.github.yoojia.events.emitter.EventEmitter;
import com.github.yoojia.events.emitter.EventFilter;
import com.github.yoojia.events.emitter.Handler;
import com.github.yoojia.events.emitter.Logger;
import com.github.yoojia.events.emitter.OnEventHandler;
import com.github.yoojia.events.emitter.Scheduler;
import com.github.yoojia.events.emitter.Target;
import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Preconditions;
import java.lang.reflect.Method;
import java.util.List;

public class NextEvents {
    private final EventEmitter mEmitter;
    private final ObjectCached mObjectCached = new ObjectCached();

    public NextEvents() {
        this(SharedScheduler.getDefault());
    }

    public NextEvents(Scheduler scheduler) {
        Preconditions.notNull(scheduler, "scheduler == null");
        this.mEmitter = new EventEmitter(scheduler);
        this.mEmitter.addOnEventHandler(new OnEventHandler(){

            @Override
            public boolean handleEvent(Object event) {
                boolean isDeadEvent = event instanceof DeadEvent;
                if (isDeadEvent) {
                    EventPayload payload = (EventPayload)((DeadEvent)event).origin;
                    if ("next.events.<dead-event>".equals(payload.name)) {
                        Logger.debug("NextEvents", "- Empty handlers for dead-event: " + payload);
                    } else {
                        NextEvents.this.emit(new EventPayload("next.events.<dead-event>", payload));
                    }
                }
                return isDeadEvent;
            }
        });
    }

    public void register(Object object) {
        this.register(object, null);
    }

    public void register(Object object, Filter<Method> methodFilter) {
        Preconditions.notNull(object, "object == null");
        TargetList targets = this.mObjectCached.findTargets(object, methodFilter);
        for (Target target : targets) {
            this.mEmitter.addTarget(target);
        }
    }

    public void unregister(Object object) {
        Preconditions.notNull(object, "object == null");
        TargetList targets = this.mObjectCached.getPresent(object);
        if (!targets.isEmpty()) {
            for (Target target : targets) {
                this.mEmitter.removeTarget(target);
            }
            this.mObjectCached.remove(object);
        }
    }

    public void just(String name) {
        this.mEmitter.emit(new EventPayload(name, null));
    }

    public void emit(String name, Object ... payloads) {
        this.mEmitter.emit(new EventPayload(name, payloads));
    }

    public void emit(EventPayload event) {
        Preconditions.notNull(event, "event == null");
        this.mEmitter.emit(event);
    }

    public void addHandler(Handler handler, EventFilter filter) {
        Preconditions.notNull(handler, "handler == null");
        Preconditions.notNull(filter, "filter == null");
        this.mEmitter.addHandler(handler, filter);
    }

    public void addHandler(Handler handler, List<EventFilter> filters) {
        Preconditions.notNull(handler, "handler == null");
        Preconditions.notNull(filters, "filters == null");
        this.mEmitter.addHandler(handler, filters);
    }

    public void removeHandler(Handler handler) {
        this.mEmitter.removeHandler(handler);
    }
}

