/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events.internal;

import com.github.yoojia.events.internal.Acceptor;
import com.github.yoojia.events.internal.Emitter;
import com.github.yoojia.events.internal.EventFilter;
import com.github.yoojia.events.internal.Handler;
import com.github.yoojia.events.internal.OnEventHandler;
import com.github.yoojia.events.internal.Scheduler;
import com.github.yoojia.events.internal.SchedulerImpl;
import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Filters;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Dispatcher {
    private final Emitter mEmitter;
    final Scheduler handlerScheduler;
    final CopyOnWriteArrayList<Acceptor> acceptors = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<OnEventHandler> handlers = new CopyOnWriteArrayList();

    public Dispatcher() {
        this(new SchedulerImpl());
    }

    public Dispatcher(Scheduler schedule) {
        this.handlerScheduler = schedule;
        this.mEmitter = new Emitter();
    }

    public void emit(Object event) {
        this.mEmitter.submit(event, this);
    }

    public void addHandler(Handler handler, EventFilter filter) {
        this.addHandler(handler, Arrays.asList(filter));
    }

    public void addHandler(Handler handler, List<EventFilter> filters) {
        this.acceptors.add(new Acceptor(handler, filters));
    }

    public void removeHandler(final Handler handler) {
        this.acceptors.removeAll(Filters.filter(this.acceptors, new Filter<Acceptor>(){

            @Override
            public boolean accept(Acceptor item) {
                return item.handler.equals(handler);
            }
        }));
    }

    public void addOnEventHandler(OnEventHandler handler) {
        this.handlers.add(handler);
    }

    public void removeOnEventHandler(OnEventHandler handler) {
        this.handlers.remove(handler);
    }
}

