/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.Element;
import com.github.yoojia.events.EventHandler;
import com.github.yoojia.events.ScheduleLooper;
import com.github.yoojia.events.internal.EventRunner;
import com.github.yoojia.events.internal.Handler;
import com.github.yoojia.events.internal.Scheduler;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;

public class ThreadsScheduler
implements Scheduler {
    private final Queue<Element> mLoopTasks = new ConcurrentLinkedQueue<Element>();
    private final ExecutorService mWorkerThreads;
    private final ExecutorService mLoopThread;
    private final ScheduleLooper mLooper = new ScheduleLooper(){

        @Override
        protected void step() {
            Element el = (Element)ThreadsScheduler.this.mLoopTasks.poll();
            if (el == null) {
                this.await();
            } else {
                ThreadsScheduler.this.invoke(el.scheduleType, el.event, el.handler);
            }
        }
    };

    public ThreadsScheduler(ExecutorService workerThreads, ExecutorService loopThread) {
        this.mWorkerThreads = workerThreads;
        this.mLoopThread = loopThread;
        this.mLoopThread.submit(this.mLooper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Object event, List<? extends Handler> handlers) {
        for (Handler handler : handlers) {
            EventHandler handler2 = (EventHandler)handler;
            int type = handler2.scheduleType();
            if (2000 == type) {
                new EventRunner(event, handler2).run();
                continue;
            }
            this.mLoopTasks.offer(new Element(event, handler2, type));
            ScheduleLooper scheduleLooper = this.mLooper;
            synchronized (scheduleLooper) {
                this.mLooper.notify();
            }
        }
    }

    public final ExecutorService getWorkerThreads() {
        return this.mWorkerThreads;
    }

    public final ExecutorService getLoopThread() {
        return this.mLoopThread;
    }

    protected void invoke(int type, Object event, Handler handler) {
        switch (type) {
            case 3000: {
                this.mWorkerThreads.submit(new EventRunner(event, handler));
                break;
            }
            case 1000: {
                handler.onErrors(new IllegalArgumentException("Unsupported <ON_MAIN_THREAD> schedule type! "));
                break;
            }
            default: {
                handler.onErrors(new IllegalArgumentException("Unsupported schedule type: " + type));
            }
        }
    }
}

