/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.Acceptors;
import com.github.yoojia.events.InternalFilter;
import com.github.yoojia.events.MethodDefine;
import com.github.yoojia.events.MethodHandler;
import com.github.yoojia.events.Methods;
import com.github.yoojia.events.internal.Acceptor;
import com.github.yoojia.events.internal.EventFilter;
import com.github.yoojia.events.supports.Filter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ObjectCached {
    private final Map<Object, Acceptors> mAcceptorCache = new ConcurrentHashMap<Object, Acceptors>();

    ObjectCached() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acceptors find(Object object, Filter<Method> methodFilter) {
        List<Method> methods = Methods.getAnnotated(object.getClass(), methodFilter);
        if (methods.isEmpty()) {
            return Acceptors.empty();
        }
        Map<Object, Acceptors> map = this.mAcceptorCache;
        synchronized (map) {
            Acceptors present = this.mAcceptorCache.get(object);
            if (present != null) {
                return present;
            }
            int size = methods.size();
            ArrayList<Acceptor> array = new ArrayList<Acceptor>(size);
            for (int i = 0; i < size; ++i) {
                Method method = methods.get(i);
                array.add(ObjectCached.create(object, method, Methods.parse(method)));
            }
            Acceptors acceptors = new Acceptors(array);
            this.mAcceptorCache.put(object, acceptors);
            return acceptors;
        }
    }

    public Acceptors getSafety(Object object) {
        Acceptors present = this.mAcceptorCache.get(object);
        if (present == null) {
            return Acceptors.empty();
        }
        return present;
    }

    public void remove(Object object) {
        this.mAcceptorCache.remove(object);
    }

    private static Acceptor create(Object object, Method method, MethodDefine args) {
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>(1);
        filters.add(new InternalFilter(args));
        return new Acceptor(MethodHandler.create(args.schedule, object, method, args), filters);
    }
}

