/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.holiday;

import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.holiday.Holiday;
import java.time.DayOfWeek;
import java.time.MonthDay;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum LocalHolidayEnum implements Holiday
{
    NEW_YEAR_DAY("\u5143\u65e6", "0101"),
    VALENTINE_DAY("\u60c5\u4eba\u8282", "0214"),
    WOMEN_DAY("\u5987\u5973\u8282", "0308"),
    ARBOR_DAY("\u690d\u6811\u8282", "0312"),
    WORLD_CONSUMER_RIGHTS_DAY("\u6d88\u8d39\u8005\u6743\u76ca\u65e5", "0315"),
    APRIL_FOOL_DAY("\u611a\u4eba\u8282", "0401"),
    INTERNATIONAL_WORKERS_DAY("\u52b3\u52a8\u8282", "0501"),
    CHINA_YOUTH_DAY("\u9752\u5e74\u8282", "0504"),
    NURSES_DAY("\u62a4\u58eb\u8282", "0512"),
    MOTHER_DAY("\u6bcd\u4eb2\u8282", "5-W-2-7"),
    CHILDREN_DAY("\u513f\u7ae5\u8282", "0601"),
    FATHER_DAY("\u7236\u4eb2\u8282", "6-W-3-7"),
    JIANDANGJIE("\u5efa\u515a\u8282", "0701"),
    JIANJUNJIE("\u5efa\u519b\u8282", "0801"),
    TEACHER_DAY("\u6559\u5e08\u8282", "0910"),
    GUOQINGJIE("\u56fd\u5e86\u8282", "1001"),
    ALL_SAINTS_DAY("\u4e07\u5723\u8282", "1101"),
    CHRISTMAS("\u5723\u8bde\u8282", "1225"),
    DEFAULT_HOLIDAY("", "");

    private final String name;
    private final String pattern;

    private LocalHolidayEnum(String name, String pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Deprecated
    public static LocalHolidayEnum getHoliday(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        MonthDay monthDay = MonthDay.from(temporal);
        String monthDayStr = monthDay.format(DateTimeFormatterUtil.MMDD_FMT);
        for (LocalHolidayEnum localHolidayEnum : LocalHolidayEnum.values()) {
            if (localHolidayEnum.getPattern().equals(monthDayStr)) {
                return localHolidayEnum;
            }
            if (!localHolidayEnum.getPattern().contains("W")) continue;
            String[] arr = localHolidayEnum.getPattern().split("-");
            int month = Integer.parseInt(arr[0]);
            int weekIndex = Integer.parseInt(arr[2]);
            int weekValue = Integer.parseInt(arr[3]);
            DayOfWeek dow = DayOfWeek.of(weekValue);
            Temporal tempTem = temporal.with(ChronoField.MONTH_OF_YEAR, month);
            Temporal targetTem = tempTem.with(TemporalAdjusters.dayOfWeekInMonth(weekIndex, dow));
            MonthDay targetMonthDay = MonthDay.from(targetTem);
            String targetMonthDayStr = targetMonthDay.format(DateTimeFormatterUtil.MMDD_FMT);
            if (!monthDayStr.equals(targetMonthDayStr)) continue;
            return localHolidayEnum;
        }
        return DEFAULT_HOLIDAY;
    }

    public static String getHolidayName(Temporal temporal) {
        return Holiday.getLocalHoliday(temporal, LocalHolidayEnum.convertToMap());
    }

    public static boolean compareMonthDay(Temporal temporal, String monthDay) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(monthDay, "monthDay");
        MonthDay monthDay1 = MonthDay.from(temporal);
        String monthDayStr = monthDay1.format(DateTimeFormatterUtil.MMDD_FMT);
        return monthDayStr.equals(monthDay);
    }

    public static Map<String, String> convertToMap() {
        HashMap<String, String> localHolidayMap = new HashMap<String, String>();
        for (LocalHolidayEnum localHolidayEnum : LocalHolidayEnum.values()) {
            localHolidayMap.put(localHolidayEnum.getPattern(), localHolidayEnum.getName());
        }
        return localHolidayMap;
    }
}

