/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.enums;

public enum WeekNameEnum {
    Mon(1, "Monday", "\u661f\u671f\u4e00"),
    Tue(2, "Tuesday", "\u661f\u671f\u4e8c"),
    Wed(3, "Wednesday", "\u661f\u671f\u4e09"),
    Thu(4, "Thursday", "\u661f\u671f\u56db"),
    Fri(5, "Friday", "\u661f\u671f\u4e94"),
    Sat(6, "Saturday", "\u661f\u671f\u516d"),
    Sun(7, "Sunday", "\u661f\u671f\u65e5");

    private static final WeekNameEnum[] ENUMS;
    private int code;
    private String fullNameEn;
    private String nameCn;

    private WeekNameEnum(int code, String fullNameEn, String nameCn) {
        this.code = code;
        this.fullNameEn = fullNameEn;
        this.nameCn = nameCn;
    }

    public static WeekNameEnum getByCode(int code) {
        if (code < 1 || code > 7) {
            return null;
        }
        return ENUMS[code - 1];
    }

    public static String getShortNameEnByCode(int code) {
        WeekNameEnum monthNameEnum = WeekNameEnum.getByCode(code);
        return monthNameEnum != null ? monthNameEnum.name() : null;
    }

    public static String getFullNameEnByCode(int code) {
        WeekNameEnum monthNameEnum = WeekNameEnum.getByCode(code);
        return monthNameEnum != null ? monthNameEnum.getFullNameEn() : null;
    }

    public static String getNameCnByCode(int code) {
        WeekNameEnum monthNameEnum = WeekNameEnum.getByCode(code);
        return monthNameEnum != null ? monthNameEnum.getNameCn() : null;
    }

    public int getCode() {
        return this.code;
    }

    public String getFullNameEn() {
        return this.fullNameEn;
    }

    public String getNameCn() {
        return this.nameCn;
    }

    static {
        ENUMS = WeekNameEnum.values();
    }
}

