/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.service;

import com.github.xiaoymin.swaggerbootstrapui.model.OrderExtensions;
import com.github.xiaoymin.swaggerbootstrapui.model.SwaggerResourceExt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ClassSupport;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spring.web.DocumentationCache;

@Component
@Qualifier(value="swaggerResourcesExtProvider")
public class SwaggerResourcesExtProvider {
    private final String swagger1Url;
    private final String swagger2Url;
    @VisibleForTesting
    boolean swagger1Available;
    @VisibleForTesting
    boolean swagger2Available;
    private final DocumentationCache documentationCache;

    @Autowired
    public SwaggerResourcesExtProvider(Environment environment, DocumentationCache documentationCache) {
        this.swagger1Url = environment.getProperty("springfox.documentation.swagger.v1.path", "/api-docs-ext");
        this.swagger2Url = environment.getProperty("springfox.documentation.swagger.v2.path", "/v2/api-docs-ext");
        this.swagger1Available = ClassSupport.classByName((String)"springfox.documentation.swagger1.web.Swagger1Controller").isPresent();
        this.swagger2Available = ClassSupport.classByName((String)"springfox.documentation.swagger2.web.Swagger2Controller").isPresent();
        this.documentationCache = documentationCache;
    }

    public List<SwaggerResourceExt> get() {
        ArrayList<SwaggerResourceExt> resources = new ArrayList<SwaggerResourceExt>();
        for (Map.Entry entry : this.documentationCache.all().entrySet()) {
            SwaggerResourceExt swaggerResource;
            String swaggerGroup = (String)entry.getKey();
            Documentation documentation = (Documentation)entry.getValue();
            List vendorExtensions = documentation.getVendorExtensions();
            if (this.swagger1Available) {
                swaggerResource = this.resource(swaggerGroup, this.swagger1Url, vendorExtensions);
                swaggerResource.setSwaggerVersion("1.2");
            }
            if (!this.swagger2Available) continue;
            swaggerResource = this.resource(swaggerGroup, this.swagger2Url, vendorExtensions);
            swaggerResource.setSwaggerVersion("2.0");
            resources.add(swaggerResource);
        }
        Collections.sort(resources, new Comparator<SwaggerResourceExt>(){

            @Override
            public int compare(SwaggerResourceExt o1, SwaggerResourceExt o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        return resources;
    }

    private SwaggerResourceExt resource(String swaggerGroup, String baseUrl, List<VendorExtension> vendorExtensions) {
        Optional ov;
        SwaggerResourceExt swaggerResource = new SwaggerResourceExt();
        swaggerResource.setName(swaggerGroup);
        swaggerResource.setUrl(this.swaggerLocation(baseUrl, swaggerGroup));
        swaggerResource.setOrder(0);
        if (vendorExtensions != null && !vendorExtensions.isEmpty() && (ov = FluentIterable.from(vendorExtensions).filter((Predicate)new Predicate<VendorExtension>(){

            public boolean apply(VendorExtension input) {
                return input.getClass().isAssignableFrom(OrderExtensions.class);
            }
        }).first()).isPresent()) {
            OrderExtensions orderExtensions = (OrderExtensions)ov.get();
            swaggerResource.setOrder(orderExtensions.getValue());
        }
        return swaggerResource;
    }

    private String swaggerLocation(String swaggerUrl, String swaggerGroup) {
        String base = (String)Optional.of((Object)swaggerUrl).get();
        if ("default".equals(swaggerGroup)) {
            return base;
        }
        return base + "?group=" + swaggerGroup;
    }
}

