/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.configuration;

import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SecurityConfiguration {
    Logger logger = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Autowired
    private Environment environment;

    @Bean
    public ProductionSecurityFilter productionSecurityFilter() {
        boolean prod = false;
        if (this.environment != null) {
            String prodStr = this.environment.getProperty("knife4j.production");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("swagger.production:{}", (Object)prodStr);
            }
            prod = Boolean.valueOf(prodStr);
        }
        ProductionSecurityFilter p = new ProductionSecurityFilter(prod);
        return p;
    }

    @Bean
    public SecurityBasicAuthFilter securityBasicAuthFilter() {
        String enableAuth;
        boolean enableSwaggerBasicAuth = false;
        String dftUserName = "admin";
        String dftPass = "123321";
        if (this.environment != null && (enableSwaggerBasicAuth = Boolean.valueOf(enableAuth = this.environment.getProperty("knife4j.basic.enable")).booleanValue())) {
            String pUser = this.environment.getProperty("knife4j.basic.username");
            String pPass = this.environment.getProperty("knife4j.basic.password");
            if (pUser != null && !"".equals(pUser)) {
                dftUserName = pUser;
            }
            if (pPass != null && !"".equals(pPass)) {
                dftPass = pPass;
            }
        }
        SecurityBasicAuthFilter securityBasicAuthFilter = new SecurityBasicAuthFilter(enableSwaggerBasicAuth, dftUserName, dftPass);
        return securityBasicAuthFilter;
    }
}

