/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.spring.support;

import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosOpenApi;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosRoute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

public class NacosSetting {
    private boolean enable;
    private String serviceUrl;
    private BasicAuth serviceAuth;
    private String secret;
    private List<NacosRoute> routes;
    private BasicAuth routeAuth;
    private Long tokenExpire = 18000L;
    private LocalDateTime secretDateTime;

    public LocalDateTime getSecretDateTime() {
        return this.secretDateTime;
    }

    public void setSecretDateTime(LocalDateTime secretDateTime) {
        this.secretDateTime = secretDateTime;
    }

    public BasicAuth getRouteAuth() {
        return this.routeAuth;
    }

    public void setRouteAuth(BasicAuth routeAuth) {
        this.routeAuth = routeAuth;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public List<NacosRoute> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<NacosRoute> routes) {
        this.routes = routes;
    }

    public BasicAuth getServiceAuth() {
        return this.serviceAuth;
    }

    public void setServiceAuth(BasicAuth serviceAuth) {
        this.serviceAuth = serviceAuth;
    }

    public void initAccessToken() {
        if (this.serviceAuth != null && this.serviceAuth.isEnable()) {
            if (this.secretDateTime == null) {
                this.setSecret(NacosOpenApi.me().getAccessToken(this.serviceUrl, this.serviceAuth));
                this.setSecretDateTime(LocalDateTime.now().plusSeconds(this.tokenExpire));
            } else {
                LocalDateTime nowTime = LocalDateTime.now();
                long seconds = Duration.between(nowTime, this.secretDateTime).getSeconds();
                if (seconds < 100L) {
                    this.setSecret(NacosOpenApi.me().getAccessToken(this.serviceUrl, this.serviceAuth));
                    this.setSecretDateTime(LocalDateTime.now().plusSeconds(this.tokenExpire));
                }
            }
        }
    }
}

